/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mh4geditor.data;

import com.zsword.mh4geditor.data.SavedataCipher;
import com.zsword.modules.io.ByteDataFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MH4GSavDataFile
extends ByteDataFile {
    private static final String DATATEXT_ENCODING = "Unicode";
    private File srcFile = null;
    private int dataOffset = 0;
    private static SavedataCipher cipher = new SavedataCipher(SavedataCipher.GameVersion.MH4G_JP);

    public MH4GSavDataFile(File file, String mode) throws IOException {
        super(MH4GSavDataFile.decryptFile(file), mode);
        this.srcFile = file;
        this.dataOffset = file.length() % 16L == 0L ? 8 : 0;
    }

    public MH4GSavDataFile(File file) throws IOException {
        this(file, "rw");
    }

    public Map<String, Object> loadCharacter(Map<String, Map<String, Object>> struct) throws IOException {
        HashMap<String, Object> info = new HashMap<String, Object>();
        long pos = this.dataOffset;
        this.seek(pos);
        for (String key : struct.keySet()) {
            Map<String, Object> def = struct.get(key);
            Integer len = (Integer)def.get("length");
            if (len == null) continue;
            if (key.startsWith("unknow")) {
                this.skipBytes(len);
                continue;
            }
            String type = (String)def.get("type");
            if ("string".equals(type)) {
                String str = this.readStringData(len);
                info.put(key, str);
                continue;
            }
            if ("bytes".equals(type)) {
                int val = this.readBytesAsInt(len);
                String str = String.format("%0" + len + "X", val);
                info.put(key, str);
                continue;
            }
            Integer val = this.readBytesAsInt(len);
            info.put(key, val);
        }
        return info;
    }

    public List<Map<String, Object>> loadCarryEquipment(Map<String, Map<String, Object>> dataStruct) throws IOException {
        long pos = 64 + this.dataOffset;
        this.seek(pos);
        return this.loadEquipmentList(7, dataStruct);
    }

    public List<Map<String, Object>> loadCarryItem(Map<String, Map<String, Object>> dataStruct) throws IOException {
        long pos = 51988 + this.dataOffset;
        this.seek(pos);
        return this.loadItemList(24, dataStruct);
    }

    public List<Map<String, Object>> loadEquipmentBox(Map<String, Map<String, Object>> dataStruct) throws IOException {
        long pos = 5950 + this.dataOffset;
        this.seek(pos);
        return this.loadEquipmentList(480, dataStruct);
    }

    public List<Map<String, Object>> loadItemBox(Map<String, Map<String, Object>> dataStruct) throws IOException {
        long pos = 350 + this.dataOffset;
        this.seek(pos);
        return this.loadItemList(1400, dataStruct);
    }

    private List<Map<String, Object>> loadItemList(int count, Map<String, Map<String, Object>> struct) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int pos = (int)this.getFilePointer();
        int size = 4;
        int i = 0;
        while (i < count) {
            int offset = pos + i * size;
            int num = 0;
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (String key : struct.keySet()) {
                Map<String, Object> def = struct.get(key);
                if ("offset".equals(key)) {
                    data.put("offset", offset);
                    continue;
                }
                Integer len = (Integer)def.get("length");
                if (len == null) continue;
                num += len.intValue();
                if (key.startsWith("unknow")) {
                    this.skipBytes(len);
                    continue;
                }
                Object val = this.readBytesAsInt(len);
                if (len != null) {
                    val = String.format("%0" + len * 2 + 'X', val);
                }
                data.put(key, (Integer)val);
            }
            if (num < size) {
                this.skipBytes(size - num);
            }
            list.add(data);
            ++i;
        }
        return list;
    }

    private List<Map<String, Object>> loadEquipmentList(int count, Map<String, Map<String, Object>> struct) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int pos = (int)this.getFilePointer();
        int size = 28;
        int i = 0;
        while (i < count) {
            int offset = pos + i * size;
            int num = 0;
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (String key : struct.keySet()) {
                Map<String, Object> def = struct.get(key);
                if ("offset".equals(key)) {
                    data.put("offset", offset);
                    continue;
                }
                Integer len = (Integer)def.get("length");
                if (len == null) continue;
                num += len.intValue();
                if (key.startsWith("unknow")) {
                    this.skipBytes(len);
                    continue;
                }
                Object val = this.readBytesAsInt(len);
                if (len != null) {
                    val = String.format("%0" + len * 2 + 'X', val);
                }
                data.put(key, (Integer)val);
            }
            if (num < size) {
                this.skipBytes(size - num);
            }
            list.add(data);
            ++i;
        }
        return list;
    }

    public String readStringData(int len) throws IOException {
        return this.readBytesAsString(len, DATATEXT_ENCODING, true);
    }

    public void writeStringData(String str) throws IOException {
        this.writeString(str, DATATEXT_ENCODING, true);
    }

    private static File decryptFile(File file) throws IOException {
        if (file.length() % 16L == 0L) {
            File outFile = new File(file.getParentFile(), String.valueOf(file.getName()) + ".temp");
            file = cipher.decryptFile(file, outFile);
        }
        return file;
    }

    private static void encryptFile(File file) throws IOException {
        if (file.length() % 16L == 0L) {
            File workFile = new File(file.getParentFile(), String.valueOf(file.getName()) + ".temp");
            cipher.encryptFile(workFile, file);
            workFile.exists();
        }
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    @Override
    public void close() throws IOException {
        super.close();
        MH4GSavDataFile.encryptFile(this.srcFile);
    }
}

