/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mh4geditor;

import com.alibaba.fastjson.JSONObject;
import com.zsword.mh4geditor.data.MH4GSavDataFile;
import com.zsword.modules.event.CellEditingEvent;
import com.zsword.modules.event.CellEditingListener;
import com.zsword.modules.swing.PanelBase;
import com.zsword.modules.swing.table.ConfigurableTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;

class SavDataEditPanel
extends PanelBase
implements ActionListener {
    private static final Map<String, JSONObject> ITEM_COLUMNS = Collections.unmodifiableMap(new LinkedHashMap<String, JSONObject>(){
        {
            this.put("offset", JSONObject.parseObject("{label:'\u4f4d\u7f6e', renderer:'hex'}"));
            this.put("item", JSONObject.parseObject("{label:'\u9053\u5177', length:2, editable:true, renderer:'hex'}"));
            this.put("num", JSONObject.parseObject("{label:'\u6570\u91cf', length:2, editable:true}"));
        }
    });
    private static final Map<String, JSONObject> EQUIPT_COLUMNS = Collections.unmodifiableMap(new LinkedHashMap<String, JSONObject>(){
        {
            this.put("offset", JSONObject.parseObject("{label:'\u4f4d\u7f6e', renderer:'hex'}"));
            this.put("type", JSONObject.parseObject("{label:'\u79cd\u7c7b', length:1, editable:true}"));
            this.put("level", JSONObject.parseObject("{label:'\u7b49\u7ea7/\u5b54\u6570', length:1, editable:true}"));
            this.put("equiptId", JSONObject.parseObject("{label:'\u88c5\u5907ID', length:2, editable:true}"));
            this.put("natureVal", JSONObject.parseObject("{label:'\u5c5e\u6027\u503c', length:1, editable:true}"));
            this.put("natureType", JSONObject.parseObject("{label:'\u5c5e\u6027\u7c7b\u578b', length:1, editable:true}"));
            this.put("decoration1", JSONObject.parseObject("{label:'\u88c5\u9970\u73e01', length:2, editable:true}"));
            this.put("decoration2", JSONObject.parseObject("{label:'\u88c5\u9970\u73e02', length:2, editable:true}"));
            this.put("decoration3", JSONObject.parseObject("{label:'\u88c5\u9970\u73e03', length:2, editable:true}"));
            this.put("sharpness", JSONObject.parseObject("{label:'\u950b\u5229/\u62801', length:1, editable:true}"));
            this.put("ability", JSONObject.parseObject("{label:'\u9644\u52a0\u80fd\u529b', length:1, editable:true}"));
            this.put("abilityVal", JSONObject.parseObject("{label:'\u62801\u503c', length:1, editable:true}"));
            this.put("insectType", JSONObject.parseObject("{label:'\u866b\u79cd\u7c7b', length:1, editable:true}"));
            this.put("grind", JSONObject.parseObject("{label:'\u7814\u78e8/\u62802', length:1, editable:true}"));
            this.put("rarity", JSONObject.parseObject("{label:'\u7a00\u6709\u5ea6', length:1, editable:true}"));
            this.put("etc", JSONObject.parseObject("{label:'\u5176\u5b83/\u62802\u503c', length:1, editable:true}"));
            this.put("strengthen", JSONObject.parseObject("{label:'\u6781\u9650\u5f3a\u5316/\u62802\u503c', length:1, editable:true}"));
            this.put("0unknow", JSONObject.parseObject("{label:'\u672a\u77e5', length:2}"));
            this.put("1unknow", JSONObject.parseObject("{label:'\u672a\u77e5', length:2}"));
            this.put("2unknow", JSONObject.parseObject("{label:'\u672a\u77e5', length:2}"));
            this.put("3unknow", JSONObject.parseObject("{label:'\u672a\u77e5', length:2}"));
        }
    });
    private JSONObject settings = null;
    private JSONObject lang = null;
    private SavDataType listType = null;
    private MH4GSavDataFile savFile;
    private JTable dataTable = null;
    private Map<String, Map<String, Object>> dataStruct = null;
    private JLabel statusText = null;
    private JFrame owner = null;

    public SavDataEditPanel(JSONObject settings, JSONObject lang, SavDataType listType) {
        this(null, settings, lang, listType);
    }

    public SavDataEditPanel(JFrame owner, JSONObject settings, JSONObject lang, SavDataType listType) {
        this.owner = owner;
        this.settings = settings;
        this.lang = lang;
        this.listType = listType;
        this.setLayout(new BorderLayout(5, 5));
        this.initItems();
    }

    protected void initItems() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        JLabel label = new JLabel("\u72b6\u6001:\u65e0");
        toolbar.add(label);
        this.statusText = label;
        this.add((Component)toolbar, "North");
        LinkedHashMap<String, Map<String, Object>> tableDef = new LinkedHashMap<String, Map<String, Object>>();
        switch (this.listType) {
            case PersonEquipt: 
            case EquiptBox: {
                tableDef.putAll(EQUIPT_COLUMNS);
                break;
            }
            case PersonItem: 
            case ItemBox: {
                tableDef.putAll(ITEM_COLUMNS);
            }
        }
        JTable table = this.createTable(tableDef);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add((Component)scrollPane, "Center");
        this.dataStruct = tableDef;
        this.dataTable = table;
    }

    public void loadDataFile(MH4GSavDataFile savFile) throws IOException {
        this.savFile = savFile;
        List<Map<String, Object>> dataList = null;
        switch (this.listType) {
            case PersonEquipt: {
                dataList = savFile.loadCarryEquipment(this.dataStruct);
                break;
            }
            case EquiptBox: {
                dataList = savFile.loadEquipmentBox(this.dataStruct);
                break;
            }
            case PersonItem: {
                dataList = savFile.loadCarryItem(this.dataStruct);
                break;
            }
            case ItemBox: {
                dataList = savFile.loadItemBox(this.dataStruct);
            }
        }
        DefaultTableModel model = (DefaultTableModel)this.dataTable.getModel();
        model.setRowCount(dataList.size());
        int i = 0;
        while (i < dataList.size()) {
            Map<String, Object> data = dataList.get(i);
            this.dataTable.setValueAt(i + 1, i, 0);
            int n = 1;
            while (n < this.dataTable.getColumnCount()) {
                String name = this.dataTable.getColumnName(n);
                Object val = data.get(name);
                this.dataTable.setValueAt(val, i, n);
                ++n;
            }
            ++i;
        }
    }

    private JTable createTable(Map<String, Map<String, Object>> config) {
        ConfigurableTable table = new ConfigurableTable(config);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(true);
        table.addCellEditingListener(new CellEditingListener(){

            @Override
            public void valueChanged(CellEditingEvent evt) {
                Object val = evt.getNewValue();
                SavDataEditPanel.this.commitEditData(val);
            }
        });
        return table;
    }

    public void addTableSelectionListener(MouseListener l) {
        this.dataTable.addMouseListener(l);
    }

    private void commitEditData(Object val) {
        try {
            int row = this.dataTable.getSelectedRow();
            int col = this.dataTable.getSelectedColumn();
            String key = this.dataTable.getColumnName(col);
            int addr = -1;
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("offset".equals(colName)) {
                    addr = (Integer)this.dataTable.getValueAt(row, i);
                    break;
                }
                ++i;
            }
            if (addr == -1) {
                throw new IllegalArgumentException("\u5730\u5740\u65e0\u6548-" + addr);
            }
            Integer len = 0;
            int pos = 0;
            for (String k : this.dataStruct.keySet()) {
                Map<String, Object> def = this.dataStruct.get(k);
                len = (Integer)def.get("length");
                if (len == null) continue;
                if (k.equals(key)) break;
                pos += len.intValue();
            }
            this.savFile.seek(addr + pos);
            if (String.class.isAssignableFrom(val.getClass())) {
                val = Integer.parseInt((String)val, 16);
            }
            this.savFile.writeInt((Integer)val, len);
        }
        catch (Exception e) {
            this.handleError(e, "\u63d0\u4ea4\u6570\u636e\u4fee\u6539\u51fa\u9519-");
        }
    }

    public TableColumn getSelectedColumn() {
        int col = this.dataTable.getSelectedColumn();
        return this.dataTable.getColumnModel().getColumn(col);
    }

    public String getSelectedCellValueCodeKey() {
        String dataKey = null;
        switch (this.listType) {
            case PersonEquipt: 
            case EquiptBox: {
                dataKey = "Equipt-";
                break;
            }
            case PersonItem: 
            case ItemBox: {
                dataKey = "";
                break;
            }
        }
        int col = this.dataTable.getSelectedColumn();
        String key = this.dataTable.getColumnName(col);
        if ("equiptId".equals(key)) {
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("type".equals(colName)) {
                    int row = this.dataTable.getSelectedRow();
                    Object colVal = this.dataTable.getValueAt(row, i);
                    if (colVal.toString().matches("07|08|09|0A|0B|0C|0D|0E|0F|10|11|12|13|14")) {
                        dataKey = "";
                    }
                    break;
                }
                ++i;
            }
        } else if (key.matches("sharpness|grind")) {
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("type".equals(colName)) {
                    int row = this.dataTable.getSelectedRow();
                    Object colVal = this.dataTable.getValueAt(row, i);
                    if ("06".equals(colVal)) {
                        key = "stoneSkill";
                    }
                    break;
                }
                ++i;
            }
        } else if ("insectType".equals(key)) {
            key = null;
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("type".equals(colName)) {
                    int row = this.dataTable.getSelectedRow();
                    Object colVal = this.dataTable.getValueAt(row, i);
                    if ("13".equals(colVal)) {
                        key = "insectType";
                    }
                    break;
                }
                ++i;
            }
        } else if (key.startsWith("decoration")) {
            key = "decoration";
        }
        return String.valueOf(dataKey) + key;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String actName = StringUtils.uncapitalize((String)cmd);
        try {
            Method method = this.getClass().getDeclaredMethod(actName, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.handleError(e, "\u6267\u884c\u547d\u4ee4\u51fa\u9519-" + cmd + ": ");
        }
    }

    public static enum SavDataType {
        PersonEquipt,
        PersonItem,
        EquiptBox,
        ItemBox;

    }
}

