/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mh4geditor;

import com.alibaba.fastjson.JSONObject;
import com.zsword.mh4geditor.data.MH4GSavDataFile;
import com.zsword.modules.event.CellEditingEvent;
import com.zsword.modules.event.CellEditingListener;
import com.zsword.modules.swing.PanelBase;
import com.zsword.modules.swing.table.ConfigurableTable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class PersonInfoPanel
extends PanelBase {
    private static final Map<String, Map<String, Object>> INFO_COLUMNS = Collections.unmodifiableMap(new LinkedHashMap<String, Map<String, Object>>(){
        {
            this.put("label", JSONObject.parseObject("{label:'\u5c5e\u6027'}"));
            this.put("value", JSONObject.parseObject("{label:'\u503c', editable:true}"));
        }
    });
    private static final Map<String, Map<String, Object>> INFO_ATTRS = Collections.unmodifiableMap(new LinkedHashMap<String, Map<String, Object>>(){
        {
            this.put("\u540d\u5b57", JSONObject.parseObject("{length:24, type:'string'}"));
            this.put("\u6027\u522b", JSONObject.parseObject("{length:1}"));
            this.put("\u9aea\u578b", JSONObject.parseObject("{length:1}"));
            this.put("\u5185\u8863\u6837\u5f0f", JSONObject.parseObject("{length:1}"));
            this.put("\u58f0\u97f3", JSONObject.parseObject("{length:1}"));
            this.put("\u77b3\u8272", JSONObject.parseObject("{length:1}"));
            this.put("\u30e1\u30a4\u30af\u6837\u5f0f", JSONObject.parseObject("{length:1}"));
            this.put("\u30e1\u30a4\u30af\u8272", JSONObject.parseObject("{length:3, type:'bytes'}"));
            this.put("\u9aea\u8272", JSONObject.parseObject("{length:3, type:'bytes'}"));
            this.put("\u5185\u8863\u8272", JSONObject.parseObject("{length:3, type:'bytes'}"));
            this.put("\u80a4\u8272", JSONObject.parseObject("{length:3, type:'bytes'}"));
            this.put("unknow1", JSONObject.parseObject("{length:2, type:'bytes'}"));
            this.put("HR", JSONObject.parseObject("{length:4}"));
            this.put("HRP", JSONObject.parseObject("{length:4}"));
            this.put("\u91d1\u94b1", JSONObject.parseObject("{length:4}"));
            this.put("\u6e38\u620f\u65f6\u95f4(sec)", JSONObject.parseObject("{length:4}"));
            this.put("\u7ee7\u627f\u65f6\u95f4(sec)", JSONObject.parseObject("{length:4}"));
        }
    });
    private MH4GSavDataFile savFile;
    private JTable dataTable = null;

    public PersonInfoPanel() {
        this.initItems();
    }

    protected void initItems() {
        JTable table = this.createTable(INFO_COLUMNS);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
        this.dataTable = table;
    }

    private JTable createTable(Map<String, Map<String, Object>> config) {
        ConfigurableTable table = new ConfigurableTable(config);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(true);
        table.addCellEditingListener(new CellEditingListener(){

            @Override
            public void valueChanged(CellEditingEvent evt) {
                Object val = evt.getNewValue();
                PersonInfoPanel.this.commitEditData(val);
            }
        });
        return table;
    }

    public void loadDataFile(MH4GSavDataFile savFile) throws IOException {
        this.savFile = savFile;
        Map<String, Map<String, Object>> struct = INFO_ATTRS;
        Map<String, Object> info = savFile.loadCharacter(struct);
        int row = 0;
        ((DefaultTableModel)this.dataTable.getModel()).setRowCount(info.size());
        for (String key : struct.keySet()) {
            if (key.startsWith("unknow")) continue;
            this.dataTable.setValueAt(row + 1, row, 0);
            this.dataTable.setValueAt(key, row, 1);
            this.dataTable.setValueAt(info.get(key), row++, 2);
        }
    }

    private void commitEditData(Object val) {
        try {
            int row = this.dataTable.getSelectedRow();
            int col = this.dataTable.getSelectedColumn();
            String key = (String)this.dataTable.getValueAt(row, 1);
            int addr = this.savFile.getDataOffset();
            if (addr == -1) {
                throw new IllegalArgumentException("\u5730\u5740\u65e0\u6548-" + addr);
            }
            Integer len = 0;
            int pos = 0;
            Map<String, Map<String, Object>> dataStruct = INFO_ATTRS;
            Map<String, Object> def = null;
            for (String k : dataStruct.keySet()) {
                def = dataStruct.get(k);
                len = (Integer)def.get("length");
                if (len == null) continue;
                if (k.equals(key)) break;
                pos += len.intValue();
            }
            this.savFile.seek(addr + pos);
            String type = (String)def.get("type");
            if ("string".equals(type)) {
                String str = (String)val;
                this.savFile.writeStringData(str);
                int r = len - str.length() * 2 - 1;
                if (r > 0) {
                    byte[] emptyData = new byte[r];
                    this.savFile.write(emptyData);
                }
                return;
            }
            if (String.class.isAssignableFrom(val.getClass())) {
                val = "bytes".equals(type) ? Integer.valueOf(Integer.parseInt((String)val, 16)) : Integer.valueOf(Integer.parseInt((String)val));
            }
            this.savFile.writeInt((Integer)val, len);
        }
        catch (Exception e) {
            this.handleError(e, "\u63d0\u4ea4\u6570\u636e\u4fee\u6539\u51fa\u9519-");
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }
}

