/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mh4geditor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.zsword.mh4geditor.PersonInfoPanel;
import com.zsword.mh4geditor.SavDataEditPanel;
import com.zsword.mh4geditor.data.MH4GSavDataFile;
import com.zsword.modules.fileio.utils.ConfigIOUtils;
import com.zsword.modules.swing.FrameBase;
import com.zsword.modules.swing.utils.ComponentUtils;
import com.zsword.saveditor.MHsavEditSupport;
import com.zsword.saveditor.gui.ValueCodesDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;

public class MH4SavEditor
extends FrameBase
implements MHsavEditSupport {
    private static final String KEY_ATTR = "key";
    private static final String VALUE_ATTR = "value";
    private static final String LABEL_ATTR = "label";
    private static final String COMMENT_ATTR = "comment";
    private static final String APP_NAME = "MH4G Sav Editor";
    private static final String _DEVPATH = "file://D:/EclipseProjs/zsword/javaee/desktopApps/gameTools/MHsavEditor/SavEditor";
    private static final String LANG_PATH = "/lang_zh_CN.json";
    private static final String SETTINGS_PATH = "/settings.json";
    private static final String EQUIPT_LIST_PATH = "/EquiptList.json";
    private static final String EQUIPT_TYPE_PATH = "/EquiptType.json";
    private static final String EQUIPT_NATURE_PATH = "/EquiptNature.json";
    private static final String EQUIPT_DECORATION_PATH = "/EquiptDecoration.json";
    private static final String ITEM_LIST_PATH = "/ItemList.json";
    private static final String STONE_SKILL_PATH = "/StoneSkill.json";
    private static final String INSECT_TYPE_PATH = "/InsectType.json";
    private static final boolean _EnableMemEdit = true;
    private JSONObject appLang = null;
    private JSONObject appSettings = null;
    private JSONObject equiptListCodes = null;
    private JSONObject equiptTypeCodes = null;
    private JSONObject equiptNatureCodes = null;
    private JSONObject equiptDecorationCodes = null;
    private JSONObject itemListCodes = null;
    private JSONObject stoneSkillCodes = null;
    private JSONObject insectTypeCodes = null;
    private MH4GSavDataFile savDataFile = null;
    private JTabbedPane mainTabPane;
    private PersonInfoPanel personInfoPanel;
    private ValueCodesDialog valueCodesDlg = null;
    private SavDataEditPanel personEquiptPanel = null;
    private SavDataEditPanel personItemPanel = null;
    private SavDataEditPanel equiptBoxPanel = null;
    private SavDataEditPanel itemBoxPanel = null;
    private Map<String, JComponent> settingsFieldMap = new HashMap<String, JComponent>();
    private Map<String, JButton> actButtonMap = new HashMap<String, JButton>();
    private JLabel statusLabel = null;
    private final String settingsPath;
    private final String languagePath;
    private String valueCodeType = null;

    private static String loadDataFilePath(String path) {
        if (1 > _State) {
            path = _DEVPATH + path;
        }
        return path;
    }

    public MH4SavEditor() {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            UIManager.setLookAndFeel(lookAndFeels[1].getClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String languagePath = MH4SavEditor.loadDataFilePath(LANG_PATH);
        String settingsPath = MH4SavEditor.loadDataFilePath(SETTINGS_PATH);
        this.languagePath = languagePath;
        this.settingsPath = settingsPath;
        this.loadLanguage();
        String cfgPath = null;
        try {
            cfgPath = settingsPath;
            this.appSettings = ConfigIOUtils.loadConfig(cfgPath);
            cfgPath = MH4SavEditor.loadDataFilePath("/data/MH4G/EquiptList.json");
            this.equiptListCodes = ConfigIOUtils.loadConfig(cfgPath, true);
            cfgPath = MH4SavEditor.loadDataFilePath("/data/MH4G/EquiptType.json");
            this.equiptTypeCodes = ConfigIOUtils.loadConfig(cfgPath, true);
            cfgPath = MH4SavEditor.loadDataFilePath("/data/MH4G/EquiptNature.json");
            this.equiptNatureCodes = ConfigIOUtils.loadConfig(cfgPath, true);
            cfgPath = MH4SavEditor.loadDataFilePath("/data/MH4G/EquiptDecoration.json");
            this.equiptDecorationCodes = ConfigIOUtils.loadConfig(cfgPath, true);
            cfgPath = MH4SavEditor.loadDataFilePath("/data/MH4G/ItemList.json");
            this.itemListCodes = ConfigIOUtils.loadConfig(cfgPath, true);
            cfgPath = MH4SavEditor.loadDataFilePath("/data/MH4G/StoneSkill.json");
            this.stoneSkillCodes = ConfigIOUtils.loadConfig(cfgPath, true);
            cfgPath = MH4SavEditor.loadDataFilePath("/data/MH4G/InsectType.json");
            this.insectTypeCodes = ConfigIOUtils.loadConfig(cfgPath, true);
        }
        catch (Exception e) {
            this.handleError(e, String.format("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6[%s]\u51fa\u9519-", cfgPath));
        }
        this.setTitle("MH4G Sav Editor ver 0.22");
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MH4SavEditor.this.onDestroy();
            }
        });
        this.initItems();
        if (-1 == _State) {
            this.loadSavFile(new File("D:/Games/3DS/MHX/mhefqs/examples/n3ds/user1"));
        }
    }

    private void loadLanguage() {
        String filePath = this.languagePath;
        try {
            this.appLang = ConfigIOUtils.loadConfig(filePath);
        }
        catch (IOException e) {
            this.handleError(e, String.format("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6[%s]\u51fa\u9519", filePath));
        }
    }

    protected void initItems() {
        GUIAction[] actions;
        Dimension size = new Dimension(1200, 600);
        this.setPreferredSize(size);
        this.setJMenuBar(this.initMenubar());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        GUIAction[] gUIActionArray = actions = new GUIAction[]{GUIAction.OpenSav, GUIAction.Exit};
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            GUIAction act = gUIActionArray[n2];
            String actName = act.name();
            JSONObject lang = this.appLang.getJSONObject(actName);
            JButton btn = new JButton(lang.getString(LABEL_ATTR));
            btn.setActionCommand(actName);
            btn.setToolTipText(lang.getString(COMMENT_ATTR));
            btn.addActionListener(this);
            toolbar.add(btn);
            this.actButtonMap.put(actName, btn);
            ++n2;
        }
        this.add((Component)toolbar, "North");
        JTabbedPane tabPane = new JTabbedPane();
        PersonInfoPanel infoPanel = new PersonInfoPanel();
        tabPane.add("\u89d2\u8272\u4fe1\u606f", infoPanel);
        this.personInfoPanel = infoPanel;
        SavDataEditPanel dataEditPanel = this.initSavEditPanel(SavDataEditPanel.SavDataType.PersonEquipt);
        tabPane.add("\u968f\u8eab\u4e0a\u88c5\u5907", dataEditPanel);
        this.personEquiptPanel = dataEditPanel;
        dataEditPanel = this.initSavEditPanel(SavDataEditPanel.SavDataType.PersonItem);
        tabPane.add("\u968f\u8eab\u9053\u5177", dataEditPanel);
        this.personItemPanel = dataEditPanel;
        dataEditPanel = this.initSavEditPanel(SavDataEditPanel.SavDataType.EquiptBox);
        tabPane.add("\u88c5\u5907\u7bb1", dataEditPanel);
        this.equiptBoxPanel = dataEditPanel;
        dataEditPanel = this.initSavEditPanel(SavDataEditPanel.SavDataType.ItemBox);
        tabPane.add("\u9053\u5177\u7bb1", dataEditPanel);
        this.itemBoxPanel = dataEditPanel;
        tabPane.setVisible(false);
        this.add(tabPane);
        this.mainTabPane = tabPane;
        JToolBar statusBar = new JToolBar();
        statusBar.setFloatable(false);
        JLabel statusLabel = new JLabel("\u672a\u8f7d\u5165");
        statusBar.add(statusLabel);
        this.add((Component)statusBar, "South");
        this.statusLabel = statusLabel;
        this.pack();
        this.center();
    }

    private JMenuBar initMenubar() {
        GUIAction[] actions;
        String labelFmt = "%s(%s)";
        JMenuBar menubar = new JMenuBar();
        String key = "File";
        JSONObject config = this.appLang.getJSONObject(key);
        char keychar = key.charAt(0);
        JMenu menu = new JMenu(String.format(labelFmt, config.get(LABEL_ATTR), Character.valueOf(keychar)));
        menu.setMnemonic(Character.toLowerCase(keychar));
        menu.setToolTipText((String)config.get(COMMENT_ATTR));
        JMenuItem item = null;
        GUIAction[] gUIActionArray = actions = new GUIAction[]{GUIAction.OpenSav, GUIAction.Exit};
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            GUIAction act = gUIActionArray[n2];
            String actName = act.name();
            config = this.appLang.getJSONObject(actName);
            keychar = actName.charAt(0);
            item = new JMenuItem(String.format(labelFmt, config.get(LABEL_ATTR), Character.valueOf(keychar)));
            item.setMnemonic(Character.toLowerCase(keychar));
            item.setActionCommand(actName);
            item.setToolTipText((String)config.get(COMMENT_ATTR));
            item.addActionListener(this);
            menu.add(item);
            ++n2;
        }
        menubar.add(menu);
        return menubar;
    }

    private SavDataEditPanel initSavEditPanel(SavDataEditPanel.SavDataType type) {
        SavDataEditPanel panel;
        final SavDataEditPanel tablePanel = panel = new SavDataEditPanel(this.appSettings, this.appLang, type);
        panel.addTableSelectionListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton()) {
                    String codeKey = tablePanel.getSelectedCellValueCodeKey();
                    MH4SavEditor.this.showValueCodesPanel(codeKey);
                }
            }
        });
        return panel;
    }

    private void showValueCodesPanel(String type) {
        if (type.equals(this.valueCodeType)) {
            return;
        }
        JSONObject codes = null;
        if ("equiptId".equals(type)) {
            codes = this.equiptListCodes;
        } else if ("Equipt-type".equals(type)) {
            codes = this.equiptTypeCodes;
        } else if ("Equipt-natureType".equals(type)) {
            codes = this.equiptNatureCodes;
        } else if ("Equipt-stoneSkill".equals(type)) {
            codes = this.stoneSkillCodes;
        } else if ("Equipt-decoration".equals(type)) {
            codes = this.equiptDecorationCodes;
        } else if ("Equipt-insectType".equals(type)) {
            codes = this.insectTypeCodes;
        } else if ("item".equals(type)) {
            codes = this.itemListCodes;
        }
        this.valueCodeType = type;
        if (codes == null) {
            if (this.valueCodesDlg != null) {
                this.valueCodesDlg.setVisible(false);
            }
            return;
        }
        if (this.valueCodesDlg == null) {
            this.valueCodesDlg = new ValueCodesDialog();
        }
        this.valueCodesDlg.loadCodes(codes);
        this.valueCodesDlg.setVisible(true);
    }

    protected void openSav() {
        String workDir = this.appSettings.getString("savFileDir");
        File savFile = this.showOpenFileDialog(workDir);
        if (savFile == null) {
            return;
        }
        workDir = savFile.getParentFile().getPath();
        this.appSettings.put("savFileDir", (Object)workDir);
        this.loadSavFile(savFile);
    }

    protected void loadSavFile(File savFile) {
        try {
            if (this.savDataFile != null) {
                this.savDataFile.close();
            }
            MH4GSavDataFile dataFile = new MH4GSavDataFile(savFile);
            if (this.personInfoPanel != null) {
                this.personInfoPanel.loadDataFile(dataFile);
            }
            if (this.personEquiptPanel != null) {
                this.personEquiptPanel.loadDataFile(dataFile);
            }
            if (this.personItemPanel != null) {
                this.personItemPanel.loadDataFile(dataFile);
            }
            if (this.equiptBoxPanel != null) {
                this.equiptBoxPanel.loadDataFile(dataFile);
            }
            if (this.itemBoxPanel != null) {
                this.itemBoxPanel.loadDataFile(dataFile);
            }
            this.savDataFile = dataFile;
            this.mainTabPane.setSelectedIndex(0);
            this.mainTabPane.setVisible(true);
            this.setStatusText("\u5b58\u6863\u6587\u4ef6:" + savFile.getPath());
        }
        catch (Exception e) {
            this.handleError(e, "\u8bfb\u53d6\u5b58\u6863\u6587\u4ef6\u51fa\u9519-");
        }
    }

    protected void saveSavAs() {
        String workDir = this.appSettings.getString("savFileDir");
        File saveFile = this.showSaveFileDialog(workDir);
        if (saveFile == null) {
            return;
        }
        workDir = saveFile.getParentFile().getPath();
        this.appSettings.put("savFileDir", (Object)workDir);
        try {
            this.savDataFile.writeToFile(saveFile, 0L, this.savDataFile.length());
            this.showMessage("\u6210\u529f\u4fdd\u5b58\u5b58\u6863\u6587\u4ef6\u4e3a" + saveFile.getPath());
        }
        catch (Exception e) {
            this.handleError(e, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u51fa\u9519-");
        }
    }

    protected Object getSettingValue(String fieldName) {
        JComponent field = this.settingsFieldMap.get(fieldName);
        Object value = ComponentUtils.getValue(field);
        return value;
    }

    protected void setStatusText(String msg) {
        this.statusLabel.setText(msg);
    }

    protected void exit() {
        this.onDestroy();
        this.dispose();
        System.exit(0);
    }

    protected void onDestroy() {
        try {
            if (this.savDataFile != null) {
                this.savDataFile.close();
            }
            ConfigIOUtils.saveConfig(this.appSettings, this.settingsPath);
        }
        catch (IOException e) {
            this.handleError(e, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u51fa\u9519-");
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String actName = StringUtils.uncapitalize((String)cmd);
        try {
            Method method = this.getClass().getDeclaredMethod(actName, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.handleError(e, "\u6267\u884c\u547d\u4ee4\u51fa\u9519-" + cmd + ": ");
        }
    }

    protected static void textToJson() {
        File file = new File(String.valueOf(_DEVPATH.substring(7)) + "/data" + ITEM_LIST_PATH);
        String line = null;
        try {
            JSONObject json = new JSONObject(true);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                line = line.toUpperCase().trim().replaceAll("\\s+", ":");
                String[] strs = line.split(":");
                JSONObject data = new JSONObject();
                if (strs.length < 2) {
                    System.out.println(line);
                }
                if (strs.length <= 3) continue;
                data.put(LABEL_ATTR, (Object)strs[1]);
                data.put(COMMENT_ATTR, (Object)strs[3]);
                json.put(strs[2], (Object)data);
            }
            reader.close();
            System.out.println(JSONObject.toJSONString((Object)json, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void csvToJson() {
        File file = new File(String.valueOf(_DEVPATH.substring(7)) + "/data" + EQUIPT_LIST_PATH);
        String line = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int row = 0;
            ArrayList<String> typeList = null;
            ArrayList<String> typeCodes = null;
            LinkedHashMap dataMap = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String[] strs = line.split(",");
                if (++row == 1) {
                    typeList = new ArrayList<String>();
                    dataMap = new LinkedHashMap();
                    int i = 1;
                    while (i < strs.length) {
                        String str = strs[i].trim();
                        typeList.add(str);
                        dataMap.put(str, new ArrayList());
                        ++i;
                    }
                    continue;
                }
                if (row == 2) {
                    typeCodes = new ArrayList<String>();
                    int i = 1;
                    while (i < strs.length) {
                        String str = strs[i].trim();
                        typeCodes.add(str);
                        ++i;
                    }
                    continue;
                }
                String idCode = strs[0].trim();
                int i = 1;
                while (i < strs.length) {
                    JSONObject data = new JSONObject();
                    data.put("id", "(" + (String)typeCodes.get(i - 1) + ")" + idCode);
                    data.put(LABEL_ATTR, strs[i].trim());
                    String type = (String)typeList.get(i - 1);
                    data.put("type", type);
                    List dataList = (List)dataMap.get(type);
                    dataList.add(data);
                    ++i;
                }
            }
            reader.close();
            JSONObject result = new JSONObject(true);
            int i = 0;
            while (i < typeList.size()) {
                String type = (String)typeList.get(i);
                List dataList = (List)dataMap.get(type);
                int n = 0;
                while (n < dataList.size()) {
                    Map data = (Map)dataList.get(n);
                    String id = (String)data.get("id");
                    if (result.containsKey(id)) {
                        System.out.println(id);
                    }
                    data.remove("id");
                    result.put(id, (Object)data);
                    ++n;
                }
                ++i;
            }
            JSONObject.writeJSONStringTo(result, new FileWriter("D:/Equipt.json"), SerializerFeature.PrettyFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum GUIAction {
        OpenSav,
        SaveSav,
        Exit,
        SaveSettings,
        UpdateRomDB,
        ConnectToServ,
        DisconnectToServ,
        EditMemData;

    }
}

