/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexeditor;

import com.github.hexeditor.binEdit;
import com.github.hexeditor.binPanel;
import com.github.hexeditor.edObj;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.JOptionPane;

public class HexBinEdit
extends binEdit {
    private int baseAddr = 0;
    private byte[] bytesData;

    public HexBinEdit(binPanel panel, boolean isApplet) {
        super(panel, isApplet);
    }

    public void loadFile(File f) {
        this.bytesData = null;
        super.loadFile(f);
    }

    public void loadData(byte[] data) {
        this.bytesData = data;
        this.topPanel.JTFile.setText(String.format("Edit byte array data-%#x", this.baseAddr));
        try {
            this.jSbSource = false;
            this.jSB.setValue(0);
            this.undoStack.push(new edObj(0L, (long)data.length, 0));
            this.doVirtual();
            this.focus();
        }
        catch (Exception e) {
            this.handleError(e, "loadData-");
        }
        this.eObjCtrlY = null;
        this.byteCtrlY = null;
    }

    protected Vector<byte[]> virtualStack(long start, long length) {
        if (this.bytesData == null) {
            return super.virtualStack(start, length);
        }
        byte[] data = new byte[2];
        int idx = 0;
        int var10 = 0;
        long pos = start;
        edObj edData = null;
        Vector<byte[]> result = new Vector<byte[]>();
        idx = 0;
        while (idx < this.v1.size()) {
            block24: {
                long endPos;
                edData = (edObj)this.v1.get(idx);
                if (start >= edData.p2) break;
                long offset = edData.p1 - edData.offset;
                long l = endPos = edData.p2 < length ? edData.p2 : length;
                if (edData.o.a1 != 4 && edData.o.a1 != 2 && (edData.o.a1 != 6 || 1 >= edData.o.B.size())) {
                    if (edData.o.a1 == 6) {
                        data[1] = (byte)edData.o.a1;
                        data[0] = (Byte)edData.o.B.get(0);
                        while (pos < endPos) {
                            result.add((byte[])data.clone());
                            ++pos;
                        }
                    } else {
                        ByteArrayInputStream input = null;
                        try {
                            try {
                                int n;
                                input = new ByteArrayInputStream(this.bytesData);
                                data[1] = (byte)(edData.p1 != edData.offset ? 1 : edData.o.a1);
                                byte[] buff = new byte[(int)(endPos - pos)];
                                int index = 0;
                                input.skip(pos - offset);
                                while (index < buff.length) {
                                    n = input.read(buff, index, buff.length - index);
                                    if (n < 0) {
                                        throw new IOException("EOF");
                                    }
                                    index += n;
                                    if (n != 0 || ++var10 != 9) continue;
                                    pos = endPos;
                                    JOptionPane.showMessageDialog((Component)((Object)this), "Unable to access file");
                                }
                                n = 0;
                                while (pos < endPos || n < var10) {
                                    data[0] = buff[n];
                                    result.add((byte[])data.clone());
                                    ++pos;
                                    ++n;
                                }
                            }
                            catch (Exception e) {
                                this.handleError(e, "virtualStack ");
                                if (input == null) break block24;
                                try {
                                    input.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    data[1] = (byte)(edData.a1 == 2 && edData.p1 != edData.offset ? 1 : edData.o.a1);
                    while (pos < endPos) {
                        data[0] = (Byte)edData.o.B.get((int)(pos - offset));
                        result.add((byte[])data.clone());
                        ++pos;
                    }
                }
            }
            if (length < edData.p2) break;
            ++idx;
        }
        return result;
    }

    protected void setStatus() {
        int valueType = this.topPanel.viewCBox[1].getSelectedIndex();
        String valueStr = "";
        if (this.firstPos != this.lastPos) {
            if (this.lastPos - this.firstPos < Integer.MAX_VALUE && this.firstPos - this.lastPos < Integer.MAX_VALUE) {
                this.topPanel.JTsizes.setText(String.valueOf(this.lastPos - this.firstPos) + " bytes selected.");
            } else {
                this.topPanel.JTsizes.setForeground(Color.red);
                this.topPanel.JTsizes.setText("Don't select more than 2^31-1 bytes!");
            }
        } else {
            StringBuffer var6 = new StringBuffer(this.isApplet ? "Offset: " : "<html>Offset:&nbsp;<b>");
            var6.append(this.coloredLong((long)this.baseAddr + this.lastPos)).append("/-").append(this.coloredLong(this.virtualSize - this.lastPos));
            this.topPanel.JTsizes.setForeground(Color.black);
            this.topPanel.JTsizes.setText(var6.toString());
        }
        this.topPanel.JTView.setText("");
        if (this.lastPos >= this.scrPos && this.scrPos + (long)this.srcV.size() >= this.lastPos && this.lastPos <= this.virtualSize) {
            int var5 = valueType != 0 && valueType != 1 ? (valueType != 2 && valueType != 3 ? (valueType != 4 && valueType != 5 && valueType != 8 ? (valueType != 6 && valueType != 7 && valueType != 9 ? (valueType != 10 && valueType != 11 ? 128 : 64) : 8) : 4) : 2) : 1;
            int var4 = (int)((this.virtualSize < this.scrPos + (long)this.srcV.size() ? this.virtualSize : this.scrPos + (long)this.srcV.size()) - this.lastPos);
            if (var4 == 0 || var4 < var5 && var5 < 9) {
                return;
            }
            var4 = var5 < var4 ? var5 : (valueType != 12 ? var4 : var4 >> 1 << 1);
            byte[] var1 = new byte[var4];
            var4 = 0;
            while (var4 < var1.length) {
                var1[var4] = ((byte[])this.srcV.get((int)(this.lastPos - this.scrPos + (long)var4)))[0];
                ++var4;
            }
            var5 = var1[0];
            try {
                if (valueType == 0) {
                    var4 = 0;
                    while (var4 < 8) {
                        valueStr = String.valueOf(valueStr) + ((var5 & 0x80) == 128 ? (char)'1' : '0');
                        if (var4 == 3) {
                            valueStr = String.valueOf(valueStr) + ' ';
                        }
                        var5 <<= 1;
                        ++var4;
                    }
                } else if (valueType == 1) {
                    valueStr = String.valueOf(Integer.toString(var5)) + " / " + Integer.toString(var5 & 0xFF);
                } else if (valueType == 8) {
                    valueStr = this.topPanel.fForm.format(Float.intBitsToFloat(new BigInteger(var1).intValue()));
                } else if (valueType == 9) {
                    valueStr = this.topPanel.dForm.format(Double.longBitsToDouble(new BigInteger(var1).longValue()));
                } else if (valueType == 10) {
                    valueStr = new String(var1, this.topPanel.cp437Available ? "cp437" : "ISO-8859-1");
                } else if (valueType == 11) {
                    valueStr = new String(var1, "UTF-8");
                } else if (valueType == 12) {
                    valueStr = new String(var1, this.topPanel.viewCBox[0].getSelectedIndex() < 1 ? "UTF-16BE" : "UTF-16LE");
                } else {
                    byte[] var2 = new byte[valueType < 6 ? valueType : (valueType == 6 ? 8 : 9)];
                    var2[0] = 0;
                    if (this.topPanel.viewCBox[0].getSelectedIndex() < 1) {
                        if ((var2.length & 1) == 0) {
                            System.arraycopy(var1, 0, var2, 0, var2.length);
                        } else {
                            System.arraycopy(var1, 0, var2, 1, var2.length - 1);
                        }
                    } else {
                        var4 = var2.length & 1;
                        while (var4 < var2.length) {
                            var2[var4] = var1[var2.length - var4 - 1];
                            ++var4;
                        }
                    }
                    valueStr = new BigInteger(var2).toString();
                }
            }
            catch (Exception var9) {
                System.err.println("setStatus " + var9);
            }
            this.topPanel.JTView.setText(valueStr.replaceAll("\t", "  ").replaceAll("\n", "  "));
            this.topPanel.JTView.setCaretPosition(0);
        }
    }

    private String coloredLong(long var1) {
        boolean var3 = this.topPanel.hexOffset;
        StringBuffer var4 = new StringBuffer(var3 ? "0x" : "");
        String var5 = var3 ? Long.toHexString(var1).toUpperCase() : Long.toString(var1);
        int var7 = var5.length();
        if (var3 && var7 % 2 == 1) {
            var5 = "0" + var5;
        }
        int n = var7 = var3 ? 0 : var7 % 3;
        if (this.isApplet) {
            var4.append(var5);
        } else {
            int var6 = 0;
            while (var6 < var5.length()) {
                if (var6 % (var3 ? 4 : 6) == var7) {
                    var4.append("<FONT color=blue>");
                }
                var4.append(var5.charAt(var6));
                if (var6 % (var3 ? 4 : 6) == (var3 ? 1 : 2 + var7)) {
                    var4.append("</FONT>");
                }
                ++var6;
            }
            if (!var3 && var6 % 6 < 3 + var7) {
                var4.append("</FONT>");
            }
        }
        return var4.toString();
    }

    public void keyTyped(KeyEvent evt) {
        boolean isUndo;
        super.keyTyped(evt);
        if (this.bytesData == null) {
            return;
        }
        edObj obj = this.eObj;
        if (obj == null) {
            return;
        }
        if (obj.a1 != 4) {
            return;
        }
        int dataLen = obj.B.size();
        int p1 = (int)obj.p1;
        int p2 = (int)obj.p2;
        boolean bl = isUndo = dataLen < 1;
        if (isUndo) {
            dataLen = p2 - p1;
        }
        if (dataLen < 1) {
            return;
        }
        byte[] oldData = new byte[dataLen];
        byte[] data = new byte[dataLen];
        int pos = p1;
        int n = 0;
        while (n < data.length) {
            oldData[n] = this.bytesData[pos + n];
            data[n] = isUndo ? oldData[n] : (Byte)obj.B.get(n);
            ++n;
        }
        p1 = this.loadOffsetAddr(p1);
        p2 = this.loadOffsetAddr(p2);
        DirtyData dirty = new DirtyData(p1, p2, oldData, data);
        this.firePropertyChange("dataChanged", oldData, dirty);
    }

    public Vector<DirtyData> loadDirtyData() {
        Vector<DirtyData> result = new Vector<DirtyData>();
        int i = 0;
        while (i < this.v1.size()) {
            edObj obj = (edObj)this.v1.get(i);
            if (obj.o.a1 != 0) {
                edObj ed = obj.o;
                byte[] data = new byte[ed.B.size()];
                int n = 0;
                while (n < data.length) {
                    data[n] = (Byte)ed.B.get(n);
                    ++n;
                }
                int p1 = this.loadOffsetAddr((int)ed.p1);
                int p2 = this.loadOffsetAddr((int)ed.p2);
                DirtyData dirty = new DirtyData(p1, p2, data);
                result.add(dirty);
            }
            ++i;
        }
        return result;
    }

    public void setBaseAddr(int baseAddr) {
        this.baseAddr = baseAddr;
    }

    public int getBaseAddr() {
        return this.baseAddr;
    }

    private int loadOffsetAddr(int pos) {
        return this.baseAddr + pos;
    }

    public int getCurPosAddr() {
        return (int)((long)this.baseAddr + this.lastPos);
    }

    public int getDataSize() {
        return this.bytesData == null ? -1 : this.bytesData.length;
    }

    protected void handleError(Exception e, String msg) {
        e.printStackTrace();
        this.topPanel.JTFile.setText("Error: " + msg + e.getMessage());
    }

    protected void focus() {
        if (!this.requestFocusInWindow()) {
            this.requestFocus();
        }
    }

    public class DirtyData {
        private long start;
        private long end;
        private byte[] oldData;
        private byte[] data;

        public DirtyData(long start, long end, byte[] data) {
            this.start = start;
            this.end = end;
            this.data = data;
        }

        public DirtyData(long start, long end, byte[] oldData, byte[] data) {
            this.start = start;
            this.end = end;
            this.oldData = oldData;
            this.data = data;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public byte[] getOldData() {
            return this.oldData;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

