/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexeditor;

import com.github.hexeditor.HexBinEdit;
import com.github.hexeditor.binPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.commons.lang3.StringUtils;

public class BinEditPanel
extends binPanel {
    private boolean injectMenu = false;
    private JTextField posField = null;
    private HexBinEdit hexEdit = null;

    public BinEditPanel(boolean isApplet, String[] args) {
        super(isApplet, args);
        this.initItems();
    }

    protected void initItems() {
        if (!this.injectMenu) {
            this.menuBar.setPreferredSize(new Dimension(0, 0));
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JLabel label = new JLabel("\u5730\u5740: 0x");
        toolbar.add(label);
        JTextField textField = new JTextField(5);
        toolbar.add(textField);
        this.posField = textField;
        toolbar.addSeparator();
        JButton btn = new JButton("\u8df3\u8f6c");
        btn.setActionCommand(GUIAction.GoToPos.name());
        btn.addActionListener((ActionListener)((Object)this));
        toolbar.add(btn);
        this.add(toolbar, "North");
        this.viewCBox[0].setSelectedIndex(1);
        this.viewCBox[1].setSelectedIndex(5);
        this.frameFile.remove((Component)this.hexV);
        GridBagConstraints gs = new GridBagConstraints();
        gs.fill = 1;
        gs.weightx = 1.0;
        gs.weighty = 1.0;
        gs.gridx = 0;
        gs.gridy = 4;
        this.hexEdit = new HexBinEdit(this, this.isApplet);
        this.hexV = this.hexEdit;
        this.frameFile.add((Component)this.hexV, gs);
        this.hexV.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("dataChanged".equals(propName)) {
                    BinEditPanel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    public int getCurPosAddr() {
        return this.hexEdit.getCurPosAddr();
    }

    public void setBasePos(int pos) {
        this.hexEdit.setBaseAddr(pos);
    }

    protected void goToPos() {
        this.goToPos(null);
    }

    public void goToPos(Integer pos) {
        String str = null;
        if (pos == null) {
            str = this.posField.getText();
            pos = Integer.parseInt(str, 16);
        } else {
            String hexStr = String.format("%x", pos);
            this.posField.setText(hexStr);
        }
        int basePos = this.hexEdit.getBaseAddr();
        int offset = pos - basePos;
        int dataSize = this.hexEdit.getDataSize();
        if (dataSize > 0 && (offset < 0 || offset > dataSize)) {
            this.firePropertyChange("outOfRange", basePos, pos);
            return;
        }
        str = "" + offset;
        this.hexEdit.goTo(str);
    }

    public void loadFile(File file) {
        this.hexEdit.loadFile(file);
    }

    public void loadData(byte[] data) {
        this.hexEdit.loadData(data);
    }

    public Object loadDirtyData() {
        return this.hexEdit.loadDirtyData();
    }

    public int loadSelectedValueType() {
        System.out.println(this.fJCB[1].getSelectedItem());
        return 4;
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (!cmd.equals(GUIAction.GoToPos.name())) {
            super.actionPerformed(evt);
            return;
        }
        try {
            cmd = StringUtils.uncapitalize((String)cmd);
            Method m = ((Object)((Object)this)).getClass().getDeclaredMethod(cmd, new Class[0]);
            m.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.handleError(e, "\u6267\u884c\u547d\u4ee4\u51fa\u9519-");
        }
    }

    protected void showMessage(String msg, String title, int type) {
        JOptionPane.showMessageDialog((Component)((Object)this), msg, title, type);
    }

    protected void handleError(Exception e, String msg) {
        e.printStackTrace();
        this.showMessage(String.valueOf(msg) + e.getMessage(), "\u51fa\u9519\u4e86!", 0);
    }

    private static enum GUIAction {
        GoToPos;

    }
}

