/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.directory;

import com.lightcrafts.platform.windows.WindowsFileUtil;
import com.lightcrafts.utils.directory.DirectoryListener;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import com.lightcrafts.utils.directory.DirectoryOnlyFilter;
import com.lightcrafts.utils.file.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import sun.awt.shell.ShellFolder;

public final class WindowsDirectoryMonitor
extends DirectoryMonitor {
    private final Map<File, Integer> m_dirMap = new HashMap<File, Integer>();

    public WindowsDirectoryMonitor() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectory(File directory) {
        Map<File, Integer> map = this.m_dirMap;
        synchronized (map) {
            if (!this.m_dirMap.containsKey(directory)) {
                try {
                    int value = WindowsFileUtil.isGUID(directory) ? WindowsDirectoryMonitor.newHashCode(directory) : WindowsDirectoryMonitor.newHandle(directory.getAbsolutePath());
                    this.m_dirMap.put(directory, value);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        Map<File, Integer> map = this.m_dirMap;
        synchronized (map) {
            for (Map.Entry<File, Integer> entry : this.m_dirMap.entrySet()) {
                if (WindowsFileUtil.isGUID(entry.getKey())) continue;
                try {
                    WindowsDirectoryMonitor.disposeHandle(entry.getValue());
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDirectory(File directory) {
        Integer value;
        Map<File, Integer> map = this.m_dirMap;
        synchronized (map) {
            value = this.m_dirMap.remove(directory);
        }
        if (value != null) {
            if (!WindowsFileUtil.isGUID(directory)) {
                try {
                    WindowsDirectoryMonitor.disposeHandle(value);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File[] getMonitoredDirectories() {
        Map<File, Integer> map = this.m_dirMap;
        synchronized (map) {
            return this.m_dirMap.keySet().toArray(new File[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasChanged(File dir) {
        if (!dir.exists()) return this.removeDirectory(dir);
        Map<File, Integer> map = this.m_dirMap;
        synchronized (map) {
            Integer value = this.m_dirMap.get(dir);
            if (value == null) return false;
            if (WindowsFileUtil.isGUID(dir)) {
                int newHashCode = WindowsDirectoryMonitor.newHashCode(dir);
                if (newHashCode == value) return false;
                this.m_dirMap.put(dir, newHashCode);
                return true;
            } else {
                try {
                    if (!WindowsDirectoryMonitor.hasChanged(value)) return false;
                    return true;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static native void disposeHandle(int var0) throws IOException;

    private static native boolean hasChanged(int var0) throws IOException;

    private static native int newHandle(String var0) throws IOException;

    private static int newHashCode(File dir) {
        ShellFolder sf;
        if (dir instanceof ShellFolder && (sf = (ShellFolder)dir).getDisplayName().equals("Network")) {
            return 0;
        }
        File[] contents = FileUtil.listFiles((File)dir, (FileFilter)DirectoryOnlyFilter.INSTANCE, (boolean)false);
        int hashCode = 0;
        if (contents != null) {
            for (File file : contents) {
                hashCode ^= file.hashCode();
            }
        }
        return hashCode;
    }

    public static void main(String[] args) throws Exception {
        WindowsDirectoryMonitor monitor = new WindowsDirectoryMonitor();
        TestListener listener = new TestListener();
        monitor.addListener(listener);
        BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String dir;
            System.out.print("> ");
            String cmd = commandLine.readLine();
            if (cmd.length() == 0) continue;
            if (cmd.startsWith("+ ")) {
                dir = cmd.substring(2);
                monitor.addDirectory(new File(dir));
                continue;
            }
            if (cmd.startsWith("- ")) {
                dir = cmd.substring(2);
                monitor.removeDirectory(new File(dir));
                continue;
            }
            System.err.println("Unknown command");
        }
    }

    static {
        System.loadLibrary("Windows");
    }

    private static final class TestListener
    implements DirectoryListener {
        private TestListener() {
        }

        public void directoryChanged(File dir) {
            System.out.println(dir.getAbsolutePath());
        }
    }
}

