/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.windows;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.PrintSettings;
import com.lightcrafts.platform.PrinterLayer;
import com.lightcrafts.platform.windows.WindowsPrintManager;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.renderable.ParameterBlock;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;

public class WindowsPrinterLayer
implements PrinterLayer {
    private String jobName = null;

    public void initialize() {
        WindowsPrintManager.initDefaultPrinter();
    }

    public void dispose() {
        WindowsPrintManager.dispose();
    }

    public void setPageFormat(PageFormat pageFormat) {
        WindowsPrintManager.setPageFormat(pageFormat);
        System.out.println("Setting PageFormat");
        WindowsPrinterLayer.dumpPage(pageFormat);
    }

    public PageFormat getPageFormat() {
        PageFormat pf = WindowsPrintManager.getPageFormat();
        if (pf != null) {
            System.out.println("Printer PageFormat");
            WindowsPrinterLayer.dumpPage(pf);
        }
        return pf;
    }

    public PageFormat pageDialog(PageFormat pageFormat) {
        WindowsPrintManager.setPageFormat(pageFormat);
        WindowsPrintManager.showPageSetupDialog(null);
        return this.getPageFormat();
    }

    public boolean printDialog() {
        return WindowsPrintManager.showPrintDialog(null);
    }

    public void setJobName(String name) {
        this.jobName = name;
    }

    public void print(ImageEditorEngine engine, ProgressThread thread, PageFormat format, PrintSettings settings) throws PrinterException {
        WindowsPrintManager.setPageFormat(format);
        Dimension resolution = WindowsPrintManager.getPrinterResolution();
        System.out.println("Our PageFormat");
        WindowsPrinterLayer.dumpPage(format);
        Dimension naturalSize = engine.getNaturalSize();
        System.out.println("settings x: " + settings.getX() + ", y: " + settings.getY() + ", width: " + settings.getWidth() + ", height: " + settings.getHeight());
        System.out.println("resolution: " + resolution);
        Dimension targetSize = new Dimension((int)(settings.getWidth() * resolution.getWidth() / 72.0), (int)(settings.getHeight() * resolution.getHeight() / 72.0));
        double xMagnification = targetSize.getWidth() / naturalSize.getWidth();
        double yMagnification = targetSize.getHeight() / naturalSize.getHeight();
        PlanarImage printImage = engine.getRendering(new Dimension((int)((double)naturalSize.width * (xMagnification < 1.0 ? xMagnification : 1.0)), (int)((double)naturalSize.height * (yMagnification < 1.0 ? yMagnification : 1.0))), settings.getColorProfile() != null ? settings.getColorProfile() : JAIContext.sRGBColorProfile, engine.getLCMSIntent(settings.getRenderingIntent()), true);
        if (xMagnification > 1.0 || yMagnification > 1.0) {
            System.out.println("Uprezzing by " + xMagnification * 100.0 + '%');
            AffineTransform xform = AffineTransform.getScaleInstance(xMagnification, yMagnification);
            RenderingHints formatHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            Interpolation interp = Interpolation.getInstance((int)3);
            ParameterBlock params = new ParameterBlock();
            params.addSource(printImage);
            params.add(xform);
            params.add(interp);
            printImage = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)formatHints);
        }
        Point location = new Point((int)(settings.getX() * resolution.getWidth() / 72.0), (int)(settings.getY() * resolution.getHeight() / 72.0));
        WindowsPrintManager.print(printImage, location, this.jobName != null ? this.jobName : "Unittled", thread);
        System.out.println("printImage: " + printImage);
        System.out.println("location: " + location);
    }

    public void cancelPrint() {
    }

    public static void dumpPage(PageFormat pageFormat) {
        System.out.println("page area w:" + pageFormat.getWidth() + ", h: " + pageFormat.getHeight() + ", o: " + pageFormat.getOrientation());
        System.out.println("imageable area x: " + pageFormat.getImageableX() + ", y: " + pageFormat.getImageableY() + ", w: " + pageFormat.getImageableWidth() + ", h: " + pageFormat.getImageableHeight());
        Paper paper = pageFormat.getPaper();
        System.out.println("paper area w:" + paper.getWidth() + ", h: " + paper.getHeight());
        System.out.println("imageable area x: " + paper.getImageableX() + ", y: " + paper.getImageableY() + ", w: " + paper.getImageableWidth() + ", h: " + paper.getImageableHeight());
    }
}

