/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.windows;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.CheckForUpdate;
import com.lightcrafts.app.ExceptionDialog;
import com.lightcrafts.app.other.OtherApplication;
import com.lightcrafts.app.other.WindowsApplication;
import com.lightcrafts.license.LicenseChecker;
import com.lightcrafts.splash.SplashImage;
import com.lightcrafts.splash.SplashWindow;
import com.lightcrafts.splash.StartupProgress;
import com.lightcrafts.utils.Version;
import java.awt.EventQueue;
import java.awt.Image;
import java.io.File;
import javax.swing.UIManager;
import sun.swing.SwingUtilities2;

public final class WindowsLauncher {
    public static void main(String[] args) {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        if (System.getProperty("java.version").startsWith("1.6")) {
            boolean lafCond = SwingUtilities2.isLocalDisplay();
            SwingUtilities2.AATextInfo aaTextInfo = SwingUtilities2.AATextInfo.getAATextInfo((boolean)lafCond);
            UIManager.getDefaults().put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
        }
        System.out.println("This is " + Version.getApplicationName() + ' ' + Version.getVersionName() + " (" + Version.getRevisionNumber() + ')');
        String javaVersion = System.getProperty("java.version");
        System.out.println("Running Java version " + javaVersion);
        try {
            String licenseText = LicenseChecker.checkLicense();
            CheckForUpdate.start();
            SplashImage image = new SplashImage(SplashImage.getDefaultSplashText((String)licenseText));
            SplashWindow.splash((Image)image);
            Application.setStartupProgress((StartupProgress)image.getStartupProgress());
            Application.main((String[])args);
            SplashWindow.disposeSplash();
            CheckForUpdate.showAlertIfAvailable();
        }
        catch (Throwable t) {
            new ExceptionDialog().handle(t);
        }
    }

    public static native void readyToOpenFiles();

    private static void openFile(String pathToFile, String parentExe) {
        final File file = new File(pathToFile);
        final OtherApplication app = WindowsApplication.getAppForExe(parentExe);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.openFrom((File)file, (OtherApplication)app);
            }
        });
    }
}

