/*
 * Decompiled with CFR 0.152.
 */
package jdk1_6.sun.text.normalizer;

import java.text.CharacterIterator;
import jdk1_6.java.text.Normalizer;
import jdk1_6.sun.text.normalizer.NormalizerImpl;
import jdk1_6.sun.text.normalizer.UCharacterIterator;
import jdk1_6.sun.text.normalizer.UCharacterProperty;
import jdk1_6.sun.text.normalizer.UTF16;
import jdk1_6.sun.text.normalizer.UnicodeSet;
import jdk1_6.sun.text.normalizer.Utility;

public final class NormalizerBase
implements Cloneable {
    private char[] buffer = new char[100];
    private int bufferStart = 0;
    private int bufferPos = 0;
    private int bufferLimit = 0;
    private UCharacterIterator text;
    private Mode mode = NFC;
    private int options = 0;
    private int currentIndex;
    private int nextIndex;
    public static final int UNICODE_3_2 = 32;
    public static final int DONE = -1;
    public static final Mode NONE = new Mode(1);
    public static final Mode NFD = new NFDMode(2);
    public static final Mode NFKD = new NFKDMode(3);
    public static final Mode NFC = new NFCMode(4);
    public static final Mode NFKC = new NFKCMode(5);
    public static final QuickCheckResult NO = new QuickCheckResult(0);
    public static final QuickCheckResult YES = new QuickCheckResult(1);
    public static final QuickCheckResult MAYBE = new QuickCheckResult(2);
    private static final int MAX_BUF_SIZE_COMPOSE = 2;
    private static final int MAX_BUF_SIZE_DECOMPOSE = 3;
    public static final int UNICODE_3_2_0_ORIGINAL = 262432;
    public static final int UNICODE_LATEST = 0;

    public NormalizerBase(String str, Mode mode, int opt) {
        this.text = UCharacterIterator.getInstance(str);
        this.mode = mode;
        this.options = opt;
    }

    public NormalizerBase(CharacterIterator iter, Mode mode) {
        this(iter, mode, 0);
    }

    public NormalizerBase(CharacterIterator iter, Mode mode, int opt) {
        this.text = UCharacterIterator.getInstance((CharacterIterator)iter.clone());
        this.mode = mode;
        this.options = opt;
    }

    public Object clone() {
        try {
            NormalizerBase copy = (NormalizerBase)super.clone();
            copy.text = (UCharacterIterator)this.text.clone();
            if (this.buffer != null) {
                copy.buffer = new char[this.buffer.length];
                System.arraycopy(this.buffer, 0, copy.buffer, 0, this.buffer.length);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public static String compose(String str, boolean compat, int options) {
        char[] src;
        char[] dest;
        if (options == 262432) {
            String mappedStr = NormalizerImpl.convert(str);
            dest = new char[mappedStr.length() * 2];
            src = mappedStr.toCharArray();
        } else {
            dest = new char[str.length() * 2];
            src = str.toCharArray();
        }
        int destSize = 0;
        UnicodeSet nx = NormalizerImpl.getNX(options);
        options &= 0xFFFFCF00;
        if (compat) {
            options |= 0x1000;
        }
        while ((destSize = NormalizerImpl.compose(src, 0, src.length, dest, 0, dest.length, options, nx)) > dest.length) {
            dest = new char[destSize];
        }
        return new String(dest, 0, destSize);
    }

    public static String decompose(String str, boolean compat) {
        return NormalizerBase.decompose(str, compat, 0);
    }

    public static String decompose(String str, boolean compat, int options) {
        int[] trailCC = new int[1];
        int destSize = 0;
        UnicodeSet nx = NormalizerImpl.getNX(options);
        if (options == 262432) {
            String mappedStr = NormalizerImpl.convert(str);
            char[] dest = new char[mappedStr.length() * 3];
            while (true) {
                if ((destSize = NormalizerImpl.decompose(mappedStr.toCharArray(), 0, mappedStr.length(), dest, 0, dest.length, compat, trailCC, nx)) <= dest.length) {
                    return new String(dest, 0, destSize);
                }
                dest = new char[destSize];
            }
        }
        char[] dest = new char[str.length() * 3];
        while ((destSize = NormalizerImpl.decompose(str.toCharArray(), 0, str.length(), dest, 0, dest.length, compat, trailCC, nx)) > dest.length) {
            dest = new char[destSize];
        }
        return new String(dest, 0, destSize);
    }

    public static int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, Mode mode, int options) {
        int length = mode.normalize(src, srcStart, srcLimit, dest, destStart, destLimit, options);
        if (length <= destLimit - destStart) {
            return length;
        }
        throw new IndexOutOfBoundsException(Integer.toString(length));
    }

    public int current() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            return this.getCodePointAt(this.bufferPos);
        }
        return -1;
    }

    public int next() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            int c = this.getCodePointAt(this.bufferPos);
            this.bufferPos += c > 65535 ? 2 : 1;
            return c;
        }
        return -1;
    }

    public int previous() {
        if (this.bufferPos > 0 || this.previousNormalize()) {
            int c = this.getCodePointAt(this.bufferPos - 1);
            this.bufferPos -= c > 65535 ? 2 : 1;
            return c;
        }
        return -1;
    }

    public void reset() {
        this.text.setIndex(0);
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    public void setIndexOnly(int index) {
        this.text.setIndex(index);
        this.currentIndex = this.nextIndex = index;
        this.clearBuffer();
    }

    public int setIndex(int index) {
        this.setIndexOnly(index);
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.endIndex();
    }

    public int getIndex() {
        if (this.bufferPos < this.bufferLimit) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    public int endIndex() {
        return this.text.getLength();
    }

    public void setMode(Mode newMode) {
        this.mode = newMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setText(String newText) {
        UCharacterIterator newIter = UCharacterIterator.getInstance(newText);
        if (newIter == null) {
            throw new InternalError("Could not create a new UCharacterIterator");
        }
        this.text = newIter;
        this.reset();
    }

    public void setText(CharacterIterator newText) {
        UCharacterIterator newIter = UCharacterIterator.getInstance(newText);
        if (newIter == null) {
            throw new InternalError("Could not create a new UCharacterIterator");
        }
        this.text = newIter;
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    private static long getPrevNorm32(UCharacterIterator src, int minC, int mask, char[] chars) {
        int ch = 0;
        ch = src.previous();
        if (ch == -1) {
            return 0L;
        }
        chars[0] = (char)ch;
        chars[1] = '\u0000';
        if (chars[0] < minC) {
            return 0L;
        }
        if (!UTF16.isSurrogate(chars[0])) {
            return NormalizerImpl.getNorm32(chars[0]);
        }
        if (UTF16.isLeadSurrogate(chars[0]) || src.getIndex() == 0) {
            chars[1] = (char)src.current();
            return 0L;
        }
        chars[1] = (char)src.previous();
        if (UTF16.isLeadSurrogate(chars[1])) {
            long norm32 = NormalizerImpl.getNorm32(chars[1]);
            if ((norm32 & (long)mask) == 0L) {
                return 0L;
            }
            return NormalizerImpl.getNorm32FromSurrogatePair(norm32, chars[0]);
        }
        src.moveIndex(1);
        return 0L;
    }

    private static int findPreviousIterationBoundary(UCharacterIterator src, IsPrevBoundary obj, int minC, int mask, char[] buffer, int[] startIndex) {
        char[] chars = new char[2];
        startIndex[0] = buffer.length;
        chars[0] = '\u0000';
        while (src.getIndex() > 0 && chars[0] != '\uffffffff') {
            boolean isBoundary = obj.isPrevBoundary(src, minC, mask, chars);
            if (startIndex[0] < (chars[1] == '\u0000' ? 1 : 2)) {
                char[] newBuf = new char[buffer.length * 2];
                System.arraycopy(buffer, startIndex[0], newBuf, newBuf.length - (buffer.length - startIndex[0]), buffer.length - startIndex[0]);
                startIndex[0] = startIndex[0] + (newBuf.length - buffer.length);
                buffer = newBuf;
                newBuf = null;
            }
            startIndex[0] = startIndex[0] - 1;
            buffer[startIndex[0]] = chars[0];
            if (chars[1] != '\u0000') {
                startIndex[0] = startIndex[0] - 1;
                buffer[startIndex[0]] = chars[1];
            }
            if (!isBoundary) continue;
            break;
        }
        return buffer.length - startIndex[0];
    }

    private static int previous(UCharacterIterator src, char[] dest, int destStart, int destLimit, Mode mode, boolean doNormalize, boolean[] pNeededToNormalize, int options) {
        int destCapacity = destLimit - destStart;
        int destLength = 0;
        if (pNeededToNormalize != null) {
            pNeededToNormalize[0] = false;
        }
        char minC = (char)mode.getMinC();
        int mask = mode.getMask();
        IsPrevBoundary isPreviousBoundary = mode.getPrevBoundary();
        if (isPreviousBoundary == null) {
            destLength = 0;
            int c = src.previous();
            if (c >= 0) {
                int c2;
                destLength = 1;
                if (UTF16.isTrailSurrogate((char)c) && (c2 = src.previous()) != -1) {
                    if (UTF16.isLeadSurrogate((char)c2)) {
                        if (destCapacity >= 2) {
                            dest[1] = (char)c;
                            destLength = 2;
                        }
                        c = c2;
                    } else {
                        src.moveIndex(1);
                    }
                }
                if (destCapacity > 0) {
                    dest[0] = (char)c;
                }
            }
            return destLength;
        }
        char[] buffer = new char[100];
        int[] startIndex = new int[1];
        int bufferLength = NormalizerBase.findPreviousIterationBoundary(src, isPreviousBoundary, minC, mask, buffer, startIndex);
        if (bufferLength > 0) {
            if (doNormalize) {
                destLength = NormalizerBase.normalize(buffer, startIndex[0], startIndex[0] + bufferLength, dest, destStart, destLimit, mode, options);
                if (pNeededToNormalize != null) {
                    pNeededToNormalize[0] = destLength != bufferLength || Utility.arrayRegionMatches(buffer, 0, dest, destStart, destLimit);
                }
            } else if (destCapacity > 0) {
                System.arraycopy(buffer, startIndex[0], dest, 0, bufferLength < destCapacity ? bufferLength : destCapacity);
            }
        }
        return destLength;
    }

    private static long getNextNorm32(UCharacterIterator src, int minC, int mask, int[] chars) {
        chars[0] = src.next();
        chars[1] = 0;
        if (chars[0] < minC) {
            return 0L;
        }
        long norm32 = NormalizerImpl.getNorm32((char)chars[0]);
        if (UTF16.isLeadSurrogate((char)chars[0])) {
            if (src.current() != -1 && UTF16.isTrailSurrogate((char)(chars[1] = src.current()))) {
                src.moveIndex(1);
                if ((norm32 & (long)mask) == 0L) {
                    return 0L;
                }
                return NormalizerImpl.getNorm32FromSurrogatePair(norm32, (char)chars[1]);
            }
            return 0L;
        }
        return norm32;
    }

    private static int findNextIterationBoundary(UCharacterIterator src, IsNextBoundary obj, int minC, int mask, char[] buffer) {
        if (src.current() == -1) {
            return 0;
        }
        int[] chars = new int[2];
        chars[0] = src.next();
        buffer[0] = (char)chars[0];
        int bufferIndex = 1;
        if (UTF16.isLeadSurrogate((char)chars[0]) && src.current() != -1) {
            chars[1] = src.next();
            if (UTF16.isTrailSurrogate((char)chars[1])) {
                buffer[bufferIndex++] = (char)chars[1];
            } else {
                src.moveIndex(-1);
            }
        }
        while (src.current() != -1) {
            if (obj.isNextBoundary(src, minC, mask, chars)) {
                src.moveIndex(chars[1] == 0 ? -1 : -2);
                break;
            }
            if (bufferIndex + (chars[1] == 0 ? 1 : 2) <= buffer.length) {
                buffer[bufferIndex++] = (char)chars[0];
                if (chars[1] == 0) continue;
                buffer[bufferIndex++] = (char)chars[1];
                continue;
            }
            char[] newBuf = new char[buffer.length * 2];
            System.arraycopy(buffer, 0, newBuf, 0, bufferIndex);
            buffer = newBuf;
            buffer[bufferIndex++] = (char)chars[0];
            if (chars[1] == 0) continue;
            buffer[bufferIndex++] = (char)chars[1];
        }
        return bufferIndex;
    }

    private static int next(UCharacterIterator src, char[] dest, int destStart, int destLimit, Mode mode, boolean doNormalize, boolean[] pNeededToNormalize, int options) {
        int destCapacity = destLimit - destStart;
        int destLength = 0;
        if (pNeededToNormalize != null) {
            pNeededToNormalize[0] = false;
        }
        char minC = (char)mode.getMinC();
        int mask = mode.getMask();
        IsNextBoundary isNextBoundary = mode.getNextBoundary();
        if (isNextBoundary == null) {
            destLength = 0;
            int c = src.next();
            if (c != -1) {
                int c2;
                destLength = 1;
                if (UTF16.isLeadSurrogate((char)c) && (c2 = src.next()) != -1) {
                    if (UTF16.isTrailSurrogate((char)c2)) {
                        if (destCapacity >= 2) {
                            dest[1] = (char)c2;
                            destLength = 2;
                        }
                    } else {
                        src.moveIndex(-1);
                    }
                }
                if (destCapacity > 0) {
                    dest[0] = (char)c;
                }
            }
            return destLength;
        }
        char[] buffer = new char[100];
        int[] startIndex = new int[1];
        int bufferLength = NormalizerBase.findNextIterationBoundary(src, isNextBoundary, minC, mask, buffer);
        if (bufferLength > 0) {
            if (doNormalize) {
                destLength = mode.normalize(buffer, startIndex[0], bufferLength, dest, destStart, destLimit, options);
                if (pNeededToNormalize != null) {
                    pNeededToNormalize[0] = destLength != bufferLength || Utility.arrayRegionMatches(buffer, startIndex[0], dest, destStart, destLength);
                }
            } else if (destCapacity > 0) {
                System.arraycopy(buffer, 0, dest, destStart, Math.min(bufferLength, destCapacity));
            }
        }
        return destLength;
    }

    private void clearBuffer() {
        this.bufferPos = 0;
        this.bufferStart = 0;
        this.bufferLimit = 0;
    }

    private boolean nextNormalize() {
        this.clearBuffer();
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.nextIndex);
        this.bufferLimit = NormalizerBase.next(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.nextIndex = this.text.getIndex();
        return this.bufferLimit > 0;
    }

    private boolean previousNormalize() {
        this.clearBuffer();
        this.nextIndex = this.currentIndex;
        this.text.setIndex(this.currentIndex);
        this.bufferLimit = NormalizerBase.previous(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.currentIndex = this.text.getIndex();
        this.bufferPos = this.bufferLimit;
        return this.bufferLimit > 0;
    }

    private int getCodePointAt(int index) {
        if (UTF16.isSurrogate(this.buffer[index])) {
            if (UTF16.isLeadSurrogate(this.buffer[index])) {
                if (index + 1 < this.bufferLimit && UTF16.isTrailSurrogate(this.buffer[index + 1])) {
                    return UCharacterProperty.getRawSupplementary(this.buffer[index], this.buffer[index + 1]);
                }
            } else if (UTF16.isTrailSurrogate(this.buffer[index]) && index > 0 && UTF16.isLeadSurrogate(this.buffer[index - 1])) {
                return UCharacterProperty.getRawSupplementary(this.buffer[index - 1], this.buffer[index]);
            }
        }
        return this.buffer[index];
    }

    public static boolean isNFSkippable(int c, Mode mode) {
        return mode.isNFSkippable(c);
    }

    public NormalizerBase(String str, Mode mode) {
        this(str, mode, 0);
    }

    public static String normalize(String str, Normalizer.Form form) {
        return NormalizerBase.normalize(str, form, 0);
    }

    public static String normalize(String str, Normalizer.Form form, int options) {
        switch (form) {
            case NFC: {
                return NFC.normalize(str, options);
            }
            case NFD: {
                return NFD.normalize(str, options);
            }
            case NFKC: {
                return NFKC.normalize(str, options);
            }
            case NFKD: {
                return NFKD.normalize(str, options);
            }
        }
        throw new IllegalArgumentException("Unexpected normalization form: " + (Object)((Object)form));
    }

    public static boolean isNormalized(String str, Normalizer.Form form) {
        return NormalizerBase.isNormalized(str, form, 0);
    }

    public static boolean isNormalized(String str, Normalizer.Form form, int options) {
        switch (form) {
            case NFC: {
                return NFC.quickCheck(str.toCharArray(), 0, str.length(), false, NormalizerImpl.getNX(options)) == YES;
            }
            case NFD: {
                return NFD.quickCheck(str.toCharArray(), 0, str.length(), false, NormalizerImpl.getNX(options)) == YES;
            }
            case NFKC: {
                return NFKC.quickCheck(str.toCharArray(), 0, str.length(), false, NormalizerImpl.getNX(options)) == YES;
            }
            case NFKD: {
                return NFKD.quickCheck(str.toCharArray(), 0, str.length(), false, NormalizerImpl.getNX(options)) == YES;
            }
        }
        throw new IllegalArgumentException("Unexpected normalization form: " + (Object)((Object)form));
    }

    private static final class IsNextTrueStarter
    implements IsNextBoundary {
        private IsNextTrueStarter() {
        }

        @Override
        public boolean isNextBoundary(UCharacterIterator src, int minC, int ccOrQCMask, int[] chars) {
            int decompQCMask = ccOrQCMask << 2 & 0xF;
            long norm32 = NormalizerBase.getNextNorm32(src, minC, ccOrQCMask | decompQCMask, chars);
            return NormalizerImpl.isTrueStarter(norm32, ccOrQCMask, decompQCMask);
        }
    }

    private static final class IsNextNFDSafe
    implements IsNextBoundary {
        private IsNextNFDSafe() {
        }

        @Override
        public boolean isNextBoundary(UCharacterIterator src, int minC, int ccOrQCMask, int[] chars) {
            return NormalizerImpl.isNFDSafe(NormalizerBase.getNextNorm32(src, minC, ccOrQCMask, chars), ccOrQCMask, ccOrQCMask & 0x3F);
        }
    }

    private static interface IsNextBoundary {
        public boolean isNextBoundary(UCharacterIterator var1, int var2, int var3, int[] var4);
    }

    private static final class IsPrevTrueStarter
    implements IsPrevBoundary {
        private IsPrevTrueStarter() {
        }

        @Override
        public boolean isPrevBoundary(UCharacterIterator src, int minC, int ccOrQCMask, char[] chars) {
            int decompQCMask = ccOrQCMask << 2 & 0xF;
            long norm32 = NormalizerBase.getPrevNorm32(src, minC, ccOrQCMask | decompQCMask, chars);
            return NormalizerImpl.isTrueStarter(norm32, ccOrQCMask, decompQCMask);
        }
    }

    private static final class IsPrevNFDSafe
    implements IsPrevBoundary {
        private IsPrevNFDSafe() {
        }

        @Override
        public boolean isPrevBoundary(UCharacterIterator src, int minC, int ccOrQCMask, char[] chars) {
            return NormalizerImpl.isNFDSafe(NormalizerBase.getPrevNorm32(src, minC, ccOrQCMask, chars), ccOrQCMask, ccOrQCMask & 0x3F);
        }
    }

    private static interface IsPrevBoundary {
        public boolean isPrevBoundary(UCharacterIterator var1, int var2, int var3, char[] var4);
    }

    public static final class QuickCheckResult {
        private int resultValue;

        private QuickCheckResult(int value) {
            this.resultValue = value;
        }
    }

    private static final class NFKCMode
    extends Mode {
        private NFKCMode(int value) {
            super(value);
        }

        @Override
        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            return NormalizerImpl.compose(src, srcStart, srcLimit, dest, destStart, destLimit, 4096, nx);
        }

        @Override
        protected String normalize(String src, int options) {
            return NormalizerBase.compose(src, true, options);
        }

        @Override
        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr(7);
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        @Override
        protected int getMask() {
            return 65314;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(7), 34, 4096, allowMaybe, nx);
        }

        @Override
        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65474L);
        }
    }

    private static final class NFCMode
    extends Mode {
        private NFCMode(int value) {
            super(value);
        }

        @Override
        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            return NormalizerImpl.compose(src, srcStart, srcLimit, dest, destStart, destLimit, 0, nx);
        }

        @Override
        protected String normalize(String src, int options) {
            return NormalizerBase.compose(src, false, options);
        }

        @Override
        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr(6);
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        @Override
        protected int getMask() {
            return 65297;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(6), 17, 0, allowMaybe, nx);
        }

        @Override
        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65473L);
        }
    }

    private static final class NFKDMode
    extends Mode {
        private NFKDMode(int value) {
            super(value);
        }

        @Override
        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            int[] trailCC = new int[1];
            return NormalizerImpl.decompose(src, srcStart, srcLimit, dest, destStart, destLimit, true, trailCC, nx);
        }

        @Override
        protected String normalize(String src, int options) {
            return NormalizerBase.decompose(src, true, options);
        }

        @Override
        protected int getMinC() {
            return 768;
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        @Override
        protected int getMask() {
            return 65288;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(9), 8, 4096, allowMaybe, nx);
        }

        @Override
        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65288L);
        }
    }

    private static final class NFDMode
    extends Mode {
        private NFDMode(int value) {
            super(value);
        }

        @Override
        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            int[] trailCC = new int[1];
            return NormalizerImpl.decompose(src, srcStart, srcLimit, dest, destStart, destLimit, false, trailCC, nx);
        }

        @Override
        protected String normalize(String src, int options) {
            return NormalizerBase.decompose(src, false, options);
        }

        @Override
        protected int getMinC() {
            return 768;
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        @Override
        protected int getMask() {
            return 65284;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(8), 4, 0, allowMaybe, nx);
        }

        @Override
        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65284L);
        }
    }

    public static class Mode {
        private int modeValue;

        private Mode(int value) {
            this.modeValue = value;
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            int srcLen = srcLimit - srcStart;
            int destLen = destLimit - destStart;
            if (srcLen > destLen) {
                return srcLen;
            }
            System.arraycopy(src, srcStart, dest, destStart, srcLen);
            return srcLen;
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, int options) {
            return this.normalize(src, srcStart, srcLimit, dest, destStart, destLimit, NormalizerImpl.getNX(options));
        }

        protected String normalize(String src, int options) {
            return src;
        }

        protected int getMinC() {
            return -1;
        }

        protected int getMask() {
            return -1;
        }

        protected IsPrevBoundary getPrevBoundary() {
            return null;
        }

        protected IsNextBoundary getNextBoundary() {
            return null;
        }

        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            if (allowMaybe) {
                return MAYBE;
            }
            return NO;
        }

        protected boolean isNFSkippable(int c) {
            return true;
        }
    }
}

