/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai.operator;

import com.lightcrafts.media.jai.util.PropertyGeneratorImpl;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.ROI;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.TransposeType;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;

class TransposePropertyGenerator
extends PropertyGeneratorImpl {
    public TransposePropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    @Override
    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            PlanarImage src = (PlanarImage)pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                return Image.UndefinedProperty;
            }
            ROI srcROI = (ROI)property;
            if (srcROI.getBounds().isEmpty()) {
                return Image.UndefinedProperty;
            }
            TransposeType transposeType = (TransposeType)pb.getObjectParameter(0);
            Interpolation interp = Interpolation.getInstance(0);
            return new ROI(JAI.create("transpose", (RenderedImage)srcROI.getAsImage(), (Object)transposeType));
        }
        return Image.UndefinedProperty;
    }
}

