/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai.operator;

import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.OperationDescriptorImpl;
import com.lightcrafts.mediax.jai.ParameterBlockJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.ROI;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.JaiI18N;
import com.lightcrafts.mediax.jai.operator.MosaicType;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;

public class MosaicDescriptor
extends OperationDescriptorImpl {
    public static final MosaicType MOSAIC_TYPE_BLEND = new MosaicType("MOSAIC_TYPE_BLEND", 1);
    public static final MosaicType MOSAIC_TYPE_OVERLAY = new MosaicType("MOSAIC_TYPE_OVERLAY", 0);
    private static final String[][] resources = new String[][]{{"GlobalName", "Mosaic"}, {"LocalName", "Mosaic"}, {"Vendor", "com.lightcrafts.media.jai"}, {"Description", JaiI18N.getString("MosaicDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/MosaicDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("MosaicDescriptor1")}, {"arg1Desc", JaiI18N.getString("MosaicDescriptor2")}, {"arg2Desc", JaiI18N.getString("MosaicDescriptor3")}, {"arg3Desc", JaiI18N.getString("MosaicDescriptor4")}, {"arg4Desc", JaiI18N.getString("MosaicDescriptor5")}};
    private static final Class[] paramClasses = new Class[]{MosaicType.class, PlanarImage[].class, ROI[].class, double[][].class, double[].class};
    private static final String[] paramNames = new String[]{"mosaicType", "sourceAlpha", "sourceROI", "sourceThreshold", "backgroundValues"};
    private static final Object[] paramDefaults = new Object[]{MOSAIC_TYPE_OVERLAY, null, null, new double[][]{{1.0}}, new double[]{0.0}};

    public MosaicDescriptor() {
        super(resources, new String[]{"rendered"}, 0, paramNames, paramClasses, paramDefaults, null);
    }

    public static RenderedOp create(RenderedImage[] sources, MosaicType mosaicType, PlanarImage[] sourceAlpha, ROI[] sourceROI, double[][] sourceThreshold, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Mosaic", "rendered");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            pb.addSource(sources[i]);
        }
        pb.setParameter("mosaicType", mosaicType);
        pb.setParameter("sourceAlpha", sourceAlpha);
        pb.setParameter("sourceROI", sourceROI);
        pb.setParameter("sourceThreshold", sourceThreshold);
        pb.setParameter("backgroundValues", backgroundValues);
        return JAI.create("Mosaic", pb, hints);
    }
}

