/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai;

import com.lightcrafts.mediax.jai.JaiI18N;
import java.io.Serializable;
import java.util.Observable;

public abstract class DeferredData
extends Observable
implements Serializable {
    protected Class dataClass;
    protected transient Object data;

    protected DeferredData(Class dataClass) {
        if (dataClass == null) {
            throw new IllegalArgumentException(JaiI18N.getString("DeferredData0"));
        }
        this.dataClass = dataClass;
    }

    public Class getDataClass() {
        return this.dataClass;
    }

    public boolean isValid() {
        return this.data != null;
    }

    protected abstract Object computeData();

    public final synchronized Object getData() {
        if (this.data == null) {
            this.setData(this.computeData());
        }
        return this.data;
    }

    protected final void setData(Object data) {
        if (data != null && !this.dataClass.isInstance(data)) {
            throw new IllegalArgumentException(JaiI18N.getString("DeferredData1"));
        }
        if (this.data == null || !this.data.equals(data)) {
            Object oldData = this.data;
            this.data = data;
            this.setChanged();
            this.notifyObservers(oldData);
        }
    }
}

