/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.test;

import com.lightcrafts.media.jai.test.OpImageTester;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.SourcelessOpImage;
import com.lightcrafts.mediax.jai.widget.ScrollingImagePanel;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;

final class RandomOpImage
extends SourcelessOpImage {
    private int maxValue;
    private int transtype;

    public RandomOpImage(int minX, int minY, int width, int height, SampleModel sampleModel, Map configuration, ImageLayout layout) {
        super(layout, configuration, sampleModel, minX, minY, width, height);
        this.transtype = sampleModel.getTransferType();
        switch (this.transtype) {
            case 0: {
                this.maxValue = 255;
                break;
            }
            case 1: {
                this.maxValue = 65535;
                break;
            }
            case 2: {
                this.maxValue = Short.MAX_VALUE;
                break;
            }
            case 3: {
                this.maxValue = Integer.MAX_VALUE;
            }
        }
        for (int y = this.getMinTileY(); y <= this.getMaxTileY(); ++y) {
            for (int x = this.getMinTileX(); x <= this.getMaxTileX(); ++x) {
                this.getTile(x, y);
            }
        }
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        int orgX = this.tileXToX(tileX);
        int orgY = this.tileYToY(tileY);
        WritableRaster dst = RasterFactory.createWritableRaster(this.sampleModel, new Point(orgX, orgY));
        Rectangle rect = new Rectangle(orgX, orgY, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        rect = rect.intersection(this.getBounds());
        int numBands = this.sampleModel.getNumBands();
        int[] p = new int[numBands];
        for (int y = rect.y; y < rect.y + rect.height; ++y) {
            for (int x = rect.x; x < rect.x + rect.width; ++x) {
                block5: for (int i = 0; i < numBands; ++i) {
                    switch (this.transtype) {
                        case 0: 
                        case 1: {
                            p[i] = (int)((double)this.maxValue * Math.random());
                            continue block5;
                        }
                        default: {
                            p[i] = (int)((double)((float)this.maxValue + 1.0f) * (Math.random() - 0.5) * 2.0);
                        }
                    }
                }
                dst.setPixel(x, y, p);
            }
        }
        return dst;
    }

    public static void main(String[] args) {
        ImageLayout layout = new ImageLayout();
        layout.setTileWidth(64);
        layout.setTileHeight(64);
        layout.setColorModel(OpImageTester.createComponentColorModel());
        RandomOpImage image = new RandomOpImage(0, 0, 100, 100, RasterFactory.createPixelInterleavedSampleModel(0, 64, 64, 3), null, layout);
        ScrollingImagePanel panel = new ScrollingImagePanel(image, 120, 120);
        Frame window = new Frame("JAI RandomOpImage Test");
        window.add(panel);
        window.pack();
        window.show();
    }
}

