/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.test;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.SourcelessOpImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;

final class CheckerboardOpImage
extends SourcelessOpImage {
    private int increment;
    private int checkerSize;
    private int numColors;

    public CheckerboardOpImage(int minX, int minY, int width, int height, SampleModel sampleModel, Map configuration, ImageLayout layout, int checkerSize, int numColors) {
        super(layout, configuration, sampleModel, minX, minY, width, height);
        if (numColors < 2) {
            numColors = 2;
        }
        this.checkerSize = checkerSize;
        this.numColors = numColors;
        switch (sampleModel.getTransferType()) {
            case 0: {
                this.increment = 255 / (numColors - 1);
                break;
            }
            case 1: {
                this.increment = 65535 / (numColors - 1);
                break;
            }
            case 2: {
                this.increment = Short.MAX_VALUE / (numColors - 1);
                break;
            }
            case 3: {
                this.increment = Integer.MAX_VALUE / (numColors - 1);
            }
        }
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        int orgX = this.tileXToX(tileX);
        int orgY = this.tileYToY(tileY);
        WritableRaster dst = RasterFactory.createWritableRaster(this.sampleModel, new Point(orgX, orgY));
        Rectangle rect = new Rectangle(orgX, orgY, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        rect = rect.intersection(this.getBounds());
        int numBands = this.sampleModel.getNumBands();
        int[] p = new int[numBands];
        for (int y = rect.y; y < rect.y + rect.height; ++y) {
            for (int x = rect.x; x < rect.x + rect.width; ++x) {
                int value = this.getPixelValue(x, y);
                for (int i = 0; i < numBands; ++i) {
                    p[i] = value;
                }
                dst.setPixel(x, y, p);
            }
        }
        return dst;
    }

    private int getPixelValue(int x, int y) {
        int squareX = x / this.checkerSize;
        int squareY = y / this.checkerSize;
        return this.increment * ((squareX + squareY) % this.numColors);
    }
}

