/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.mlib;

import com.lightcrafts.media.jai.mlib.MediaLibAccessor;
import com.lightcrafts.media.jai.mlib.MlibAffineBicubicOpImage;
import com.lightcrafts.media.jai.mlib.MlibAffineBilinearOpImage;
import com.lightcrafts.media.jai.mlib.MlibAffineNearestOpImage;
import com.lightcrafts.media.jai.mlib.MlibAffineTableOpImage;
import com.lightcrafts.media.jai.mlib.MlibCopyOpImage;
import com.lightcrafts.media.jai.mlib.MlibScaleBicubicOpImage;
import com.lightcrafts.media.jai.mlib.MlibScaleBilinearOpImage;
import com.lightcrafts.media.jai.mlib.MlibScaleNearestOpImage;
import com.lightcrafts.media.jai.mlib.MlibScaleTableOpImage;
import com.lightcrafts.media.jai.opimage.RIFUtil;
import com.lightcrafts.media.jai.opimage.TranslateIntOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.InterpolationBicubic;
import com.lightcrafts.mediax.jai.InterpolationBicubic2;
import com.lightcrafts.mediax.jai.InterpolationBilinear;
import com.lightcrafts.mediax.jai.InterpolationNearest;
import com.lightcrafts.mediax.jai.InterpolationTable;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;

public class MlibAffineRIF
implements RenderedImageFactory {
    private static final float TOLERANCE = 0.01f;

    @Override
    public RenderedImage create(ParameterBlock args, RenderingHints hints) {
        boolean isBilevel;
        ImageLayout layout = RIFUtil.getImageLayoutHint(hints);
        AffineTransform transform = (AffineTransform)args.getObjectParameter(0);
        Interpolation interp = (Interpolation)args.getObjectParameter(1);
        double[] backgroundValues = (double[])args.getObjectParameter(2);
        RenderedImage source = args.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibCompatible(args, layout) || !MediaLibAccessor.hasSameNumBands(args, layout) || source.getTileWidth() >= 32768 || source.getTileHeight() >= 32768) {
            return null;
        }
        SampleModel sm = source.getSampleModel();
        boolean bl = isBilevel = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
        if (isBilevel) {
            return null;
        }
        BorderExtender extender = RIFUtil.getBorderExtenderHint(hints);
        double[] tr = new double[6];
        transform.getMatrix(tr);
        if (tr[0] == 1.0 && tr[3] == 1.0 && tr[2] == 0.0 && tr[1] == 0.0 && tr[4] == 0.0 && tr[5] == 0.0) {
            return new MlibCopyOpImage(source, hints, layout);
        }
        if (tr[0] == 1.0 && tr[3] == 1.0 && tr[2] == 0.0 && tr[1] == 0.0 && Math.abs(tr[4] - (double)((int)tr[4])) < (double)0.01f && Math.abs(tr[5] - (double)((int)tr[5])) < (double)0.01f && layout == null) {
            return new TranslateIntOpImage(source, hints, (int)tr[4], (int)tr[5]);
        }
        if (tr[0] > 0.0 && tr[2] == 0.0 && tr[1] == 0.0 && tr[3] > 0.0) {
            if (interp instanceof InterpolationNearest) {
                return new MlibScaleNearestOpImage(source, extender, hints, layout, (float)tr[0], (float)tr[3], (float)tr[4], (float)tr[5], interp);
            }
            if (interp instanceof InterpolationBilinear) {
                return new MlibScaleBilinearOpImage(source, extender, hints, layout, (float)tr[0], (float)tr[3], (float)tr[4], (float)tr[5], interp);
            }
            if (interp instanceof InterpolationBicubic || interp instanceof InterpolationBicubic2) {
                return new MlibScaleBicubicOpImage(source, extender, hints, layout, (float)tr[0], (float)tr[3], (float)tr[4], (float)tr[5], interp);
            }
            if (interp instanceof InterpolationTable) {
                return new MlibScaleTableOpImage(source, extender, hints, layout, (float)tr[0], (float)tr[3], (float)tr[4], (float)tr[5], interp);
            }
            return null;
        }
        if (interp instanceof InterpolationNearest) {
            return new MlibAffineNearestOpImage(source, extender, (Map)hints, layout, transform, interp, backgroundValues);
        }
        if (interp instanceof InterpolationBilinear) {
            return new MlibAffineBilinearOpImage(source, extender, (Map)hints, layout, transform, interp, backgroundValues);
        }
        if (interp instanceof InterpolationBicubic || interp instanceof InterpolationBicubic2) {
            return new MlibAffineBicubicOpImage(source, extender, (Map)hints, layout, transform, interp, backgroundValues);
        }
        if (interp instanceof InterpolationTable) {
            return new MlibAffineTableOpImage(source, extender, (Map)hints, layout, transform, interp, backgroundValues);
        }
        return null;
    }
}

