/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.codecimpl;

import com.lightcrafts.media.jai.codec.FPXDecodeParam;
import com.lightcrafts.media.jai.codec.ImageCodec;
import com.lightcrafts.media.jai.codec.ImageDecodeParam;
import com.lightcrafts.media.jai.codec.ImageDecoder;
import com.lightcrafts.media.jai.codec.ImageEncodeParam;
import com.lightcrafts.media.jai.codec.ImageEncoder;
import com.lightcrafts.media.jai.codec.SeekableStream;
import com.lightcrafts.media.jai.codecimpl.FPXImageDecoder;
import com.lightcrafts.media.jai.codecimpl.JaiI18N;
import java.awt.image.RenderedImage;
import java.io.OutputStream;

public final class FPXCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "fpx";
    }

    @Override
    public Class getEncodeParamClass() {
        return null;
    }

    @Override
    public Class getDecodeParamClass() {
        return FPXDecodeParam.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return false;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        throw new RuntimeException(JaiI18N.getString("FPXCodec0"));
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new FPXImageDecoder(src, param);
    }

    @Override
    public int getNumHeaderBytes() {
        return 8;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        return header[0] == -48 && header[1] == -49 && header[2] == 17 && header[3] == -32 && header[4] == -95 && header[5] == -79 && header[6] == 26 && header[7] == -31;
    }
}

