/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeConfigurationManager;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceDefaultTreeCellRenderer;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceTreeUI
extends BasicTreeUI {
    public static String SELECTED_INDICES = "substancelaf.internal.treeSelectedIndices";
    public static String ROLLED_OVER_INDEX = "substancelaf.internal.treeRolledOverIndex";
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();
    protected PropertyChangeListener substancePropertyChangeListener;
    protected TreeSelectionListener substanceSelectionFadeListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    protected MouseListener substanceRowSelectionListener;
    private boolean isInside = false;

    public static ComponentUI createUI(JComponent tree) {
        return new SubstanceTreeUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (SubstanceCoreUtilities.toBleedWatermark(this.tree)) {
            this.tree.setOpaque(false);
        }
        HashMap<TreePathId, Object> selected = new HashMap<TreePathId, Object>();
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath selectionPath : this.tree.getSelectionPaths()) {
                selected.put(new TreePathId(selectionPath), selectionPath.getLastPathComponent());
            }
        }
        this.tree.putClientProperty(SELECTED_INDICES, selected);
    }

    protected void uninstallDefaults() {
        this.tree.putClientProperty(SELECTED_INDICES, null);
        super.uninstallDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean canHaveSubstanceEffects;
        float fadeCoef;
        int leadIndex;
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        if (this.tree.hasFocus()) {
            TreePath leadPath = this.tree.getLeadSelectionPath();
            leadIndex = this.getRowForPath(this.tree, leadPath);
        } else {
            leadIndex = -1;
        }
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
        boolean isWatermarkBleed = SubstanceCoreUtilities.toBleedWatermark(this.tree);
        TreePathId pathId = new TreePathId(path);
        boolean isSelectedAnim = FadeTracker.getInstance().isTracked((Component)this.tree, pathId, FadeTracker.FadeKind.SELECTION);
        boolean isRolloverAnim = FadeTracker.getInstance().isTracked((Component)this.tree, pathId, FadeTracker.FadeKind.ROLLOVER);
        TreePathId currRoPath = (TreePathId)this.tree.getClientProperty(ROLLED_OVER_INDEX);
        boolean isRollover = currRoPath != null && currRoPath.path.equals(path);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite(this.tree));
        if (!isWatermarkBleed && component.getBackground() != null) {
            g2d.setColor(component.getBackground());
            if (this.tree.getComponentOrientation().isLeftToRight()) {
                g2d.fillRect(bounds.x, bounds.y, clipBounds.width, bounds.height);
            } else {
                g2d.fillRect(clipBounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
        float alphaForBackground = 0.0f;
        if (this.tree.isRowSelected(row) || isSelectedAnim) {
            if (isSelectedAnim) {
                fadeCoef = FadeTracker.getInstance().getFade10((Component)this.tree, pathId, FadeTracker.FadeKind.SELECTION);
                alphaForBackground = 0.7f * fadeCoef / 10.0f;
            } else {
                alphaForBackground = 0.7f;
            }
        }
        if (isRolloverAnim) {
            fadeCoef = FadeTracker.getInstance().getFade10((Component)this.tree, pathId, FadeTracker.FadeKind.ROLLOVER);
            alphaForBackground = Math.max(alphaForBackground, 0.4f * fadeCoef / 10.0f);
        } else if (isRollover) {
            alphaForBackground = Math.max(alphaForBackground, 0.4f);
        }
        boolean bl = canHaveSubstanceEffects = !(component instanceof DefaultTreeCellRenderer);
        if (canHaveSubstanceEffects && alphaForBackground > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.tree, alphaForBackground));
            backgroundDelegate.update(g2d, component, new Rectangle(this.tree.getInsets().left, bounds.y, this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left, bounds.height), SubstanceCoreUtilities.getTheme(this.tree, true).getHighlightBackgroundTheme(), true);
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.tree));
        }
        if (component instanceof JComponent) {
            JComponent jRenderer;
            JComponent jComponent = jRenderer = (JComponent)component;
            synchronized (jComponent) {
                boolean newOpaque;
                boolean bl2 = newOpaque = !this.tree.isRowSelected(row);
                if (SubstanceCoreUtilities.toBleedWatermark(this.tree)) {
                    newOpaque = false;
                }
                newOpaque = newOpaque && canHaveSubstanceEffects;
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g2d, component, this.tree, bounds.x, bounds.y, Math.max(this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left - bounds.x, bounds.width), bounds.height, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            }
        } else {
            this.rendererPane.paintComponent(g2d, component, this.tree, bounds.x, bounds.y, Math.max(clipBounds.width, bounds.width), bounds.height, true);
        }
        if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
            if (!this.tree.getComponentOrientation().isLeftToRight()) {
                bounds.x -= 4;
            }
            this.paintExpandControl(g2d, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
        g2d.dispose();
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean toPaint;
        boolean bl = toPaint = !this.tree.isEnabled() || this.isInside || !FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, this.tree);
        if (FadeTracker.getInstance().isTracked(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND)) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.tree, FadeTracker.getInstance().getFade10(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND) / 10.0f));
            super.paintExpandControl(graphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            graphics.dispose();
        } else if (toPaint) {
            super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean toPaint;
        boolean bl = toPaint = !this.tree.isEnabled() || this.isInside || !FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, this.tree);
        if (FadeTracker.getInstance().isTracked(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND)) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.tree, FadeTracker.getInstance().getFade10(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND) / 10.0f));
            super.paintHorizontalPartOfLeg(graphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            graphics.dispose();
        } else if (toPaint) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        boolean toPaint;
        boolean bl = toPaint = !this.tree.isEnabled() || this.isInside || !FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, this.tree);
        if (FadeTracker.getInstance().isTracked(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND)) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.tree, FadeTracker.getInstance().getFade10(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND) / 10.0f));
            super.paintVerticalPartOfLeg(graphics, clipBounds, insets, path);
            graphics.dispose();
        } else if (toPaint) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new SubstanceDefaultTreeCellRenderer();
    }

    protected void installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    SubstanceTreeUI.this.tree.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(SubstanceTreeUI.this.tree));
                }
            }
        };
        this.tree.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceSelectionFadeListener = new MyTreeSelectionListener();
        this.tree.getSelectionModel().addTreeSelectionListener(this.substanceSelectionFadeListener);
        this.substanceRowSelectionListener = new RowSelectionListener();
        this.tree.addMouseListener(this.substanceRowSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.tree.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.tree.addMouseListener(this.substanceFadeRolloverListener);
    }

    protected void uninstallListeners() {
        this.tree.removeMouseListener(this.substanceRowSelectionListener);
        this.substanceRowSelectionListener = null;
        this.tree.getSelectionModel().removeTreeSelectionListener(this.substanceSelectionFadeListener);
        this.substanceSelectionFadeListener = null;
        this.tree.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.tree.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.tree.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    private class RowSelectionListener
    extends MouseAdapter {
        private RowSelectionListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            TreePath closestPath = SubstanceTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (closestPath == null) {
                return;
            }
            Rectangle bounds = SubstanceTreeUI.this.tree.getPathBounds(closestPath);
            if (e.getY() >= bounds.y && e.getY() < bounds.y + bounds.height && (e.getX() < bounds.x || e.getX() > bounds.x + bounds.width)) {
                if (SubstanceTreeUI.this.isLocationInExpandControl(closestPath, e.getX(), e.getY())) {
                    return;
                }
                SubstanceTreeUI.this.selectPathForEvent(closestPath, e);
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            SubstanceTreeUI.this.isInside = true;
            if (FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree)) {
                FadeTracker.getInstance().trackFadeIn(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree, false, null);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            SubstanceTreeUI.this.isInside = false;
            if (FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree)) {
                FadeTracker.getInstance().trackFadeOut(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree, false, null);
            }
            this.fadeOut();
            SubstanceTreeUI.this.tree.putClientProperty(ROLLED_OVER_INDEX, null);
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            SubstanceTreeUI.this.isInside = true;
            this.handleMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            TreePath closestPath = SubstanceTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            Rectangle bounds = SubstanceTreeUI.this.tree.getPathBounds(closestPath);
            if (bounds == null) {
                this.fadeOut();
                SubstanceTreeUI.this.tree.putClientProperty(ROLLED_OVER_INDEX, null);
                return;
            }
            if (e.getY() < bounds.y || e.getY() > bounds.y + bounds.height) {
                this.fadeOut();
                SubstanceTreeUI.this.tree.putClientProperty(ROLLED_OVER_INDEX, null);
                return;
            }
            TreePathId newPathId = new TreePathId(closestPath);
            TreePathId currPathId = (TreePathId)SubstanceTreeUI.this.tree.getClientProperty(ROLLED_OVER_INDEX);
            if (currPathId != null && newPathId.equals(currPathId)) {
                return;
            }
            this.fadeOut();
            FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTreeUI.this.tree, newPathId, false, (FadeTracker.FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, closestPath));
            SubstanceTreeUI.this.tree.putClientProperty(ROLLED_OVER_INDEX, newPathId);
        }

        private void fadeOut() {
            TreePathId prevRoPath = (TreePathId)SubstanceTreeUI.this.tree.getClientProperty(ROLLED_OVER_INDEX);
            if (prevRoPath == null) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTreeUI.this.tree, prevRoPath, false, (FadeTracker.FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, prevRoPath.path));
        }
    }

    protected class PathRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected JTree tree;
        protected TreePath treePath;

        public PathRepaintCallback(JTree tree, TreePath treePath) {
            this.tree = tree;
            this.treePath = treePath;
        }

        public void fadeEnded(FadeTracker.FadeKind fadeKind) {
            this.repaintPath();
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind, float fade10) {
            this.repaintPath();
        }

        private void repaintPath() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTreeUI.this.tree == null) {
                        return;
                    }
                    Rectangle boundsBuffer = new Rectangle();
                    Rectangle bounds = SubstanceTreeUI.this.treeState.getBounds(PathRepaintCallback.this.treePath, boundsBuffer);
                    if (bounds != null) {
                        bounds.x = 0;
                        bounds.width = PathRepaintCallback.this.tree.getWidth();
                        Insets insets = PathRepaintCallback.this.tree.getInsets();
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        PathRepaintCallback.this.tree.repaint(bounds);
                    }
                }
            });
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Map currSelected = (Map)SubstanceTreeUI.this.tree.getClientProperty(SELECTED_INDICES);
            if (SubstanceTreeUI.this.tree.getSelectionPaths() != null) {
                for (TreePath selectionPath : SubstanceTreeUI.this.tree.getSelectionPaths()) {
                    TreePathId pathId = new TreePathId(selectionPath);
                    if (currSelected.containsKey(pathId)) continue;
                    FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.SELECTION, (Component)SubstanceTreeUI.this.tree, pathId, false, (FadeTracker.FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, selectionPath));
                    currSelected.put(pathId, selectionPath.getLastPathComponent());
                }
            }
            Iterator it = currSelected.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (SubstanceTreeUI.this.tree.getSelectionModel().isPathSelected(((TreePathId)entry.getKey()).path)) continue;
                FadeTracker.getInstance().trackFadeOut(FadeTracker.FadeKind.SELECTION, (Component)SubstanceTreeUI.this.tree, (Comparable)entry.getKey(), false, (FadeTracker.FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, ((TreePathId)entry.getKey()).path));
                it.remove();
            }
        }
    }

    protected static class TreePathId
    implements Comparable {
        protected TreePath path;

        public TreePathId(TreePath path) {
            this.path = path;
        }

        public int compareTo(Object o) {
            if (o instanceof TreePathId) {
                Object[] path2Objs;
                TreePathId otherId = (TreePathId)o;
                Object[] path1Objs = this.path.getPath();
                if (path1Objs.length != (path2Objs = otherId.path.getPath()).length) {
                    return 1;
                }
                for (int i = 0; i < path1Objs.length; ++i) {
                    if (path1Objs[i].equals(path2Objs[i])) continue;
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            Object[] pathObjs = this.path.getPath();
            int result = pathObjs[0].hashCode();
            for (int i = 1; i < pathObjs.length; ++i) {
                result ^= pathObjs[i].hashCode();
            }
            return result;
        }
    }
}

