/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBackgroundDelegate;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceMenuItemUI
extends BasicMenuItemUI
implements SubstanceMenu {
    private static SubstanceMenuBackgroundDelegate backgroundDelegate = new SubstanceMenuBackgroundDelegate(0.4f);
    protected FadeStateListener substanceFadeStateListener;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    protected PropertyChangeListener substancePropertyListener;
    protected static Graphics graphics;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceMenuItemUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceFadeStateListener = new FadeStateListener(this.menuItem, this.menuItem.getModel(), null);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceMenuItemUI.this.substanceFadeStateListener != null) {
                        SubstanceMenuItemUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceMenuItemUI.this.substanceFadeStateListener = new FadeStateListener(SubstanceMenuItemUI.this.menuItem, SubstanceMenuItemUI.this.menuItem.getModel(), null);
                    SubstanceMenuItemUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void uninstallListeners() {
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners();
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int textOffset = MenuUtilities.getTextOffset(g, menuItem);
        backgroundDelegate.paintBackground(g, menuItem, bgColor, true, textOffset);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        MenuUtilities.lineupTextRectangle(g, menuItem, textRect, this.defaultTextIconGap);
        super.paintText(g, menuItem, textRect, text);
    }

    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return null;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        SubstanceMenuItemUI ui = (SubstanceMenuItemUI)this.menuItem.getUI();
        int offset1 = MenuUtilities.getTextOffset(graphics, this.menuItem);
        int offset2 = MenuUtilities.getTextOffset(graphics, this.menuItem, ui.getAcceleratorFont(), checkIcon, arrowIcon, defaultTextIconGap);
        int textOffset = offset1 - offset2;
        return new Dimension(superDim.width + textOffset, superDim.height);
    }

    static {
        BufferedImage dummy = new BufferedImage(1, 1, 2);
        graphics = dummy.getGraphics();
    }
}

