/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.swing;

import com.lightcrafts.utils.swing.NoIcon;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public final class NoncancelableProgressDialog
extends JDialog {
    private static final int msgBarPadding = 5;
    private JProgressBar m_progressBar;

    public NoncancelableProgressDialog(Frame parent, String message) {
        super(parent, "", true);
        this.setDefaultCloseOperation(0);
        this.setModal(false);
        final JLabel messageLabel = new JLabel(message);
        this.m_progressBar = new JProgressBar();
        this.m_progressBar.setIndeterminate(true);
        JPanel layoutPanel = new JPanel(null){

            @Override
            public void doLayout() {
                Dimension size = this.getSize();
                messageLabel.setLocation(0, 0);
                messageLabel.setSize(messageLabel.getPreferredSize());
                Dimension mSize = messageLabel.getPreferredSize();
                Dimension pSize = NoncancelableProgressDialog.this.m_progressBar.getPreferredSize();
                NoncancelableProgressDialog.this.m_progressBar.setLocation(0, mSize.height + 5);
                NoncancelableProgressDialog.this.m_progressBar.setSize(size.width, pSize.height);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension mSize = messageLabel.getPreferredSize();
                Dimension pSize = NoncancelableProgressDialog.this.m_progressBar.getPreferredSize();
                return new Dimension(Math.max(mSize.width, pSize.width), mSize.height + pSize.height + 5);
            }
        };
        JButton cancelButton = new JButton("Cancel ");
        cancelButton.setEnabled(false);
        JOptionPane panel = new JOptionPane(layoutPanel, 1, 0, NoIcon.INSTANCE, new Object[]{cancelButton});
        layoutPanel.add(messageLabel);
        layoutPanel.add(this.m_progressBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(panel);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
    }

    @Override
    public void dispose() {
        if (this.m_progressBar != null) {
            final Container barParent = this.m_progressBar.getParent();
            if (barParent != null) {
                final JProgressBar progreesBarCopy = this.m_progressBar;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        barParent.remove(progreesBarCopy);
                    }
                });
            }
            this.m_progressBar = null;
        }
        super.dispose();
    }
}

