/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.filecache;

import com.lightcrafts.utils.filecache.FileCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

final class FileCacheOutputStream
extends FileOutputStream {
    private File m_file;
    private final FileCache m_owningCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.m_file != null) {
                File temp = this.m_file;
                this.m_file = null;
                this.m_owningCache.notifyAboutCloseOf(temp);
            }
        }
    }

    FileCacheOutputStream(File file, FileCache owningCache) throws FileNotFoundException {
        super(file);
        this.m_file = file;
        this.m_owningCache = owningCache;
    }
}

