/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.filecache;

import com.lightcrafts.utils.file.FileIterator;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.filecache.CacheFile;
import com.lightcrafts.utils.filecache.CacheFileComparator;
import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.filecache.FileCacheFilter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.PriorityQueue;

final class FileCacheMonitor
extends Thread {
    private boolean m_abortInitialize;
    private final PriorityQueue<CacheFile> m_filesByLastAccessTime = new PriorityQueue<CacheFile>(11, CacheFileComparator.INSTANCE);
    private final HashMap<String, CacheFile> m_filesByPath = new HashMap();
    private final FileCache m_owningCache;
    private boolean m_stop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initialize();
        while (!this.m_stop) {
            while (this.m_owningCache.getSize() > this.m_owningCache.getCapacity()) {
                if (this.m_stop) {
                    return;
                }
                CacheFile fileToRemove = this.getNextFileToRemove();
                long size = fileToRemove.length();
                fileToRemove.delete();
                this.m_owningCache.addToCacheSize(-size);
            }
            FileCacheMonitor fileCacheMonitor = this;
            synchronized (fileCacheMonitor) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    FileCacheMonitor(FileCache owningCache) {
        super("FileCacheMonitor");
        this.setDaemon(true);
        this.setPriority(1);
        this.m_owningCache = owningCache;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addFile(File file) throws IOException {
        CacheFile newCacheFile;
        CacheFile oldCacheFile;
        long newLastAccessTime = FileUtil.getLastAccessTimeOf(file);
        String path = file.getAbsolutePath();
        Serializable serializable = this.m_filesByPath;
        synchronized (serializable) {
            oldCacheFile = this.m_filesByPath.get(path);
            if (oldCacheFile != null && oldCacheFile.lastAccessTime() == newLastAccessTime) {
                return false;
            }
            newCacheFile = new CacheFile(path, newLastAccessTime);
            this.m_filesByPath.put(path, newCacheFile);
        }
        serializable = this.m_filesByLastAccessTime;
        synchronized (serializable) {
            if (oldCacheFile != null) {
                this.m_filesByLastAccessTime.remove(oldCacheFile);
            }
            this.m_filesByLastAccessTime.add(newCacheFile);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.m_abortInitialize = true;
        Serializable serializable = this.m_filesByLastAccessTime;
        synchronized (serializable) {
            this.m_filesByLastAccessTime.clear();
        }
        serializable = this.m_filesByPath;
        synchronized (serializable) {
            this.m_filesByPath.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsFile(File file) {
        String path = file.getAbsolutePath();
        HashMap<String, CacheFile> hashMap = this.m_filesByPath;
        synchronized (hashMap) {
            return this.m_filesByPath.containsKey(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        this.m_stop = true;
        FileCacheMonitor fileCacheMonitor = this;
        synchronized (fileCacheMonitor) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFile(File file) {
        CacheFile cacheFile;
        String path = file.getAbsolutePath();
        Serializable serializable = this.m_filesByPath;
        synchronized (serializable) {
            cacheFile = this.m_filesByPath.remove(path);
        }
        if (cacheFile != null) {
            serializable = this.m_filesByLastAccessTime;
            synchronized (serializable) {
                this.m_filesByLastAccessTime.remove(cacheFile);
            }
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void initialize() {
        long totalSize = 0L;
        FileIterator i = new FileIterator(this.m_owningCache.getCacheDirectory(), FileCacheFilter.INSTANCE, true);
        while (i.hasNext()) {
            if (this.m_abortInitialize || this.m_stop) {
                return;
            }
            File file = i.next();
            long size = file.length();
            if (size <= 0L) continue;
            try {
                this.addFile(file);
                totalSize += size;
            }
            catch (IOException e) {}
        }
        if (totalSize > 0L) {
            this.m_owningCache.addToCacheSize(totalSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheFile getNextFileToRemove() {
        while (true) {
            CacheFile file;
            PriorityQueue<CacheFile> priorityQueue = this.m_filesByLastAccessTime;
            synchronized (priorityQueue) {
                file = this.m_filesByLastAccessTime.poll();
            }
            try {
                long currentLastAccessTime = FileUtil.getLastAccessTimeOf(file);
                if (file.lastAccessTime() == currentLastAccessTime) {
                    return file;
                }
                String path = file.getAbsolutePath();
                file = new CacheFile(path, currentLastAccessTime);
                Serializable serializable = this.m_filesByPath;
                synchronized (serializable) {
                    this.m_filesByPath.put(path, file);
                }
                serializable = this.m_filesByLastAccessTime;
                synchronized (serializable) {
                    this.m_filesByLastAccessTime.add(file);
                    continue;
                }
            }
            catch (IOException e) {
                this.m_owningCache.addToCacheSize(-file.length());
                HashMap<String, CacheFile> hashMap = this.m_filesByPath;
                synchronized (hashMap) {
                    this.m_filesByPath.remove(file.getAbsolutePath());
                }
                file.delete();
                continue;
            }
            break;
        }
    }
}

