/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.cache;

import com.lightcrafts.utils.cache.CacheStore;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DirectFileCacheStore
implements CacheStore {
    private RandomAccessFile m_file;

    public DirectFileCacheStore(File cacheFile) throws IOException {
        cacheFile.deleteOnExit();
        this.m_file = new RandomAccessFile(cacheFile, "rw");
    }

    @Override
    public synchronized void clear() throws IOException {
        this.m_file.setLength(0L);
    }

    @Override
    public synchronized void dispose() throws IOException {
        if (this.m_file != null) {
            this.m_file.close();
            this.m_file = null;
        }
    }

    @Override
    public ByteBuffer getByteBuffer(int size) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }

    @Override
    public synchronized long getSize() throws IOException {
        return this.m_file.length();
    }

    @Override
    public synchronized void readFromStore(long pos, ByteBuffer buf) throws IOException {
        this.m_file.seek(pos);
        this.m_file.read(buf.array(), 0, buf.limit());
        buf.position(0);
    }

    @Override
    public synchronized void writeToStore(long pos, ByteBuffer buf) throws IOException {
        buf.position(0);
        this.m_file.seek(pos);
        this.m_file.write(buf.array(), 0, buf.limit());
    }
}

