/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.bytebuffer;

import com.lightcrafts.utils.bytebuffer.ArrayByteBuffer;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import sun.nio.ch.DirectBuffer;

public final class LCMappedByteBuffer
extends ArrayByteBuffer
implements Closeable {
    public LCMappedByteBuffer(File file) throws IOException {
        this(file, FileChannel.MapMode.READ_ONLY);
    }

    public LCMappedByteBuffer(File file, FileChannel.MapMode mode) throws IOException {
        this(file, 0L, file.length(), mode);
    }

    public LCMappedByteBuffer(File file, long position, long size, FileChannel.MapMode mode) throws IOException {
        super(ByteBufferUtil.map(file, position, size, mode));
    }

    @Override
    public void close() {
        ByteBuffer buf = this.getByteBuffer();
        if (buf instanceof DirectBuffer) {
            ((DirectBuffer)((Object)buf)).cleaner().clean();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

