/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.bytebuffer;

import com.lightcrafts.utils.CloseableManager;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;

public class FileByteBuffer
extends LCByteBuffer
implements Closeable {
    private final CloseableManager m_closeableManager;
    private final File m_file;
    private ByteOrder m_order;
    private RandomAccessFile m_raf;

    public FileByteBuffer(File file, CloseableManager closeableManager) {
        super((int)file.length());
        this.m_file = file;
        this.m_order = ByteOrder.BIG_ENDIAN;
        this.m_closeableManager = closeableManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.m_raf != null) {
            try {
                this.m_raf.close();
            }
            finally {
                this.m_raf = null;
            }
        }
    }

    public void dispose() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte get(int pos) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 1 > this.limit()) {
            throw new BufferUnderflowException();
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            return this.getRAF(offsetPos).readByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCByteBuffer get(byte[] dest, int offset, int length) throws IOException {
        int pos = this.position();
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + length > this.limit()) {
            throw new BufferUnderflowException();
        }
        int totalBytesRead = 0;
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            int bytesRead;
            RandomAccessFile raf = this.getRAF(offsetPos);
            while ((bytesRead = raf.read(dest, offset, length)) != -1) {
                totalBytesRead += bytesRead;
                if (bytesRead == length) break;
                offset += bytesRead;
                length -= bytesRead;
            }
        }
        this.position(pos + totalBytesRead);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int pos) throws IOException {
        long value;
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 8 > this.limit()) {
            throw new BufferUnderflowException();
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            value = this.getRAF(offsetPos).readLong();
        }
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            value = Long.reverseBytes(value);
        }
        return Double.longBitsToDouble(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int pos) throws IOException {
        int value;
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 4 > this.limit()) {
            throw new BufferUnderflowException();
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            value = this.getRAF(offsetPos).readInt();
        }
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            value = Integer.reverseBytes(value);
        }
        return Float.intBitsToFloat(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int pos) throws IOException {
        int value;
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 4 > this.limit()) {
            throw new BufferUnderflowException();
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            value = this.getRAF(offsetPos).readInt();
        }
        return this.order() == ByteOrder.BIG_ENDIAN ? value : Integer.reverseBytes(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int pos) throws IOException {
        long value;
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 8 > this.limit()) {
            throw new BufferUnderflowException();
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            value = this.getRAF(offsetPos).readLong();
        }
        return this.order() == ByteOrder.BIG_ENDIAN ? value : Long.reverseBytes(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int pos) throws IOException {
        short value;
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 2 > this.limit()) {
            throw new BufferUnderflowException();
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            value = this.getRAF(offsetPos).readShort();
        }
        return this.order() == ByteOrder.BIG_ENDIAN ? value : Short.reverseBytes(value);
    }

    @Override
    public ByteOrder order() {
        return this.m_order;
    }

    @Override
    public LCByteBuffer order(ByteOrder order) {
        this.m_order = order;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileByteBuffer put(int pos, byte value) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 1 > this.limit()) {
            throw new BufferOverflowException();
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            this.getRAF(offsetPos).writeByte(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileByteBuffer putDouble(int pos, double value) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 8 > this.limit()) {
            throw new BufferOverflowException();
        }
        long valueAsLong = Double.doubleToLongBits(value);
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            valueAsLong = Long.reverseBytes(valueAsLong);
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            this.getRAF(offsetPos).writeLong(valueAsLong);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileByteBuffer putFloat(int pos, float value) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 4 > this.limit()) {
            throw new BufferOverflowException();
        }
        int valueAsInt = Float.floatToIntBits(value);
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            valueAsInt = Integer.reverseBytes(valueAsInt);
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            this.getRAF(offsetPos).writeInt(valueAsInt);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileByteBuffer putInt(int pos, int value) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 4 > this.limit()) {
            throw new BufferOverflowException();
        }
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            value = Integer.reverseBytes(value);
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            this.getRAF(offsetPos).writeInt(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileByteBuffer putLong(int pos, long value) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 8 > this.limit()) {
            throw new BufferOverflowException();
        }
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            value = Long.reverseBytes(value);
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            this.getRAF(offsetPos).writeLong(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileByteBuffer putShort(int pos, short value) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 2 > this.limit()) {
            throw new BufferOverflowException();
        }
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            value = Short.reverseBytes(value);
        }
        FileByteBuffer fileByteBuffer = this;
        synchronized (fileByteBuffer) {
            this.getRAF(offsetPos).writeShort(value);
        }
        return this;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private RandomAccessFile getRAF(long pos) throws IOException {
        if (this.m_raf == null) {
            if (this.m_closeableManager != null) {
                this.m_closeableManager.manage(this);
            }
            this.m_raf = new RandomAccessFile(this.m_file, "r");
        }
        this.m_raf.seek(pos);
        return this.m_raf;
    }
}

