/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;

public class WeakHashSet<E>
extends AbstractSet<E> {
    private final WeakHashMap<E, Boolean> m_map;

    public WeakHashSet() {
        this.m_map = new WeakHashMap();
    }

    public WeakHashSet(Collection<E> c) {
        this.m_map = new WeakHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public WeakHashSet(int initialCapacity) {
        this.m_map = new WeakHashMap(initialCapacity);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        this.m_map = new WeakHashMap(initialCapacity, loadFactor);
    }

    @Override
    public boolean add(E o) {
        return this.m_map.put(o, Boolean.TRUE) == null;
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m_map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.m_map.remove(o) == Boolean.TRUE;
    }

    @Override
    public int size() {
        return this.m_map.size();
    }
}

