/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileComputationListener;
import com.lightcrafts.mediax.jai.TileRequest;
import com.lightcrafts.utils.ProgressIndicator;
import java.awt.Point;
import java.awt.image.Raster;

public class RenderingProgressTask
implements TileComputationListener {
    int numTiles = 0;
    int computedTiles = 0;
    PlanarImage theImage = null;
    ProgressIndicator theListener;

    public RenderingProgressTask(ProgressIndicator listener) {
        this.theListener = listener;
    }

    public synchronized void registerImage(PlanarImage image) {
        if (this.theImage != null) {
            this.deRegisterImage(this.theImage);
        }
        Point[] tileIndices = image.getTileIndices(image.getBounds());
        this.numTiles = tileIndices.length;
        this.theListener.setMinimum(0);
        this.theListener.setMaximum(this.numTiles);
        this.computedTiles = 0;
        image.addTileComputationListener((TileComputationListener)this);
        image.queueTiles(tileIndices);
        this.theImage = image;
        this.theListener.setMaximum(tileIndices.length);
    }

    public synchronized void deRegisterImage(PlanarImage image) {
        image.removeTileComputationListener((TileComputationListener)this);
        this.numTiles = 0;
        this.theImage = null;
    }

    public boolean done() {
        return this.computedTiles >= this.numTiles;
    }

    public synchronized void tileComputed(Object eventSource, TileRequest[] tileRequests, PlanarImage image, int tileX, int tileY, Raster tile) {
        ++this.computedTiles;
        this.theListener.incrementBy(1);
        if (this.computedTiles >= this.numTiles) {
            this.theListener.setIndeterminate(true);
        }
        this.notify();
    }

    public synchronized void tileCancelled(Object eventSource, TileRequest[] tileRequests, PlanarImage image, int tileX, int tileY) {
        System.err.println("RP: cancelled tile " + tileX + ":" + tileY);
        this.notify();
    }

    public synchronized void tileComputationFailure(Object eventSource, TileRequest[] tileRequests, PlanarImage image, int tileX, int tileY, Throwable situation) {
        System.err.println("RP: failed tile " + tileX + ":" + tileY);
        this.notify();
    }
}

