/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.utils.LCMS;
import java.awt.color.ICC_Profile;
import java.util.LinkedHashMap;
import java.util.Map;

public class LCMS_Profile {
    private static Map profileCache = new LRUHashMap(20);
    private long cmsProfileHandle = 0L;

    public LCMS_Profile(ICC_Profile iccProfile) {
        Long handle = (Long)profileCache.get(iccProfile);
        if (handle == null) {
            byte[] data = iccProfile.getData();
            this.cmsProfileHandle = LCMS.cmsOpenProfileFromMem(data, data.length);
            profileCache.put(iccProfile, new Long(this.cmsProfileHandle));
        } else {
            this.cmsProfileHandle = handle;
        }
    }

    public void dispose() {
        if (this.cmsProfileHandle != 0L) {
            LCMS.cmsCloseProfile(this.cmsProfileHandle);
            this.cmsProfileHandle = 0L;
        }
    }

    private static final class LRUHashMap
    extends LinkedHashMap {
        private final int max_entries;

        LRUHashMap(int initialCapacity, float loadFactor, int max_entries) {
            super(initialCapacity, loadFactor, true);
            this.max_entries = max_entries;
        }

        public LRUHashMap(int initialCapacity, int max_entries) {
            super(initialCapacity);
            this.max_entries = max_entries;
        }

        public LRUHashMap(int max_entries) {
            this.max_entries = max_entries;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.max_entries;
        }
    }
}

