/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ColorProfileInfo
implements Comparable {
    private static final int PROFILE_NAME_LENGTH_OFFSET = 11;
    private ICC_Profile m_iccProfile;
    private final String m_name;
    private final String m_path;

    public ColorProfileInfo(String name, String path) {
        if (name == null || path == null) {
            throw new IllegalArgumentException();
        }
        this.m_name = name;
        this.m_path = path;
    }

    public static List<ColorProfileInfo> arrangeForMenu(Collection<ColorProfileInfo> profiles) {
        TreeMap<String, String> sortedByPath = new TreeMap<String, String>();
        for (ColorProfileInfo cpi : profiles) {
            sortedByPath.put(cpi.getPath(), cpi.getName());
        }
        ArrayList<ColorProfileInfo> result = new ArrayList<ColorProfileInfo>();
        File currentDirectory = null;
        for (Map.Entry me : sortedByPath.entrySet()) {
            String path = (String)me.getKey();
            File file = new File(path);
            File directory = file.getParentFile();
            if (!directory.equals(currentDirectory)) {
                if (currentDirectory != null) {
                    result.add(null);
                }
                currentDirectory = directory;
            }
            String name = (String)me.getValue();
            result.add(new ColorProfileInfo(name, path));
        }
        int start = -1;
        for (int i = 0; i < result.size() - 1; ++i) {
            if (result.get(i) == null) {
                start = i;
                continue;
            }
            int end = result.size();
            for (int j = i + 1; j < end; ++j) {
                if (result.get(j) != null) continue;
                end = j;
                break;
            }
            Collections.sort(result.subList(start + 1, end));
            start = end = i;
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        ColorProfileInfo c = (ColorProfileInfo)o;
        return this.getName().toUpperCase().compareTo(c.getName().toUpperCase());
    }

    public boolean equals(Object o) {
        if (o instanceof ColorProfileInfo) {
            ColorProfileInfo c = (ColorProfileInfo)o;
            return this.m_name.equals(c.m_name) && this.m_path.equals(c.m_path);
        }
        return false;
    }

    public static ICC_Profile getExportICCProfileFor(String name) {
        Collection<ColorProfileInfo> exportProfiles = Platform.getPlatform().getExportProfiles();
        for (ColorProfileInfo cpi : exportProfiles) {
            if (!cpi.getName().equals(name)) continue;
            return cpi.getICCProfile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ICC_Profile getICCProfile() {
        if (this.m_iccProfile == null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.m_path);
                this.m_iccProfile = ICC_Profile.getInstance(in);
            }
            catch (IOException e) {
                System.err.println("Bad color profile path: " + this.m_path);
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return this.m_iccProfile;
    }

    public String getName() {
        return this.m_name;
    }

    public static String getNameOf(ICC_Profile profile) {
        byte[] descData = profile.getData(1684370275);
        if (descData == null) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(descData, 11, descData.length - 11);
        return ByteBufferUtil.getString(buf, buf.get() - 1, "UTF-8");
    }

    public String getPath() {
        return this.m_path;
    }

    public int hashCode() {
        return this.m_name.hashCode() ^ this.m_path.hashCode();
    }

    public String toString() {
        return this.m_name;
    }
}

