/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit.journal;

import com.lightcrafts.ui.toolkit.journal.JournalListener;
import com.lightcrafts.ui.toolkit.journal.TapQueueControl;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.swing.JFrame;

public class InputEventJournal
implements AWTEventListener {
    public static InputEventJournal Instance = new InputEventJournal();
    private static final int DefaultTapControlKeyCode = 92;
    private TapQueueControl tapControl;
    private XmlDocument doc = new XmlDocument("InputEventJournal");
    private LinkedList listeners = new LinkedList();
    int eventCount;

    private InputEventJournal() {
    }

    public void start() {
        this.tapControl = new TapQueueControl(this, 92);
    }

    public boolean isJournaling() {
        return this.tapControl != null;
    }

    public void stop() {
        this.tapControl.dispose();
        this.tapControl = null;
    }

    public void write(OutputStream out) throws IOException {
        this.doc.write(out);
    }

    public void read(InputStream in) throws IOException, XMLException {
        this.doc = new XmlDocument(in);
        XmlNode root = this.doc.getRoot();
        XmlNode[] children = root.getChildren();
        JFrame frame = new JFrame();
        for (int n = 0; n < children.length; ++n) {
            this.createEvent(frame, children[n]);
        }
    }

    public void clear() {
        this.doc = new XmlDocument("InputEventJournal");
        this.eventCount = 0;
    }

    public void replay(final JFrame frame) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                XmlNode[] nodes = InputEventJournal.this.doc.getRoot().getChildren();
                if (nodes.length == 0) {
                    return;
                }
                InputEventJournal.this.notifyJournalStarted(true);
                InputEventJournal.this.eventCount = 0;
                try {
                    int index = 0;
                    InputEvent event = InputEventJournal.this.createEvent(frame, nodes[index++]);
                    long when = event.getWhen();
                    do {
                        queue.postEvent(event);
                        InputEventJournal.this.notifyJournalEvent(true);
                        if (nodes.length <= index) continue;
                        event = InputEventJournal.this.createEvent(frame, nodes[index++]);
                        Thread.sleep(event.getWhen() - when);
                        when = event.getWhen();
                    } while (nodes.length > index);
                }
                catch (XMLException e) {
                    System.err.println("Error decoding event history: " + e.getMessage());
                }
                catch (InterruptedException e) {
                    System.err.println("History replay interrupted");
                }
                InputEventJournal.this.notifyJournalEnded(true);
            }
        };
        Thread thread = new Thread(runnable, "InputEvent Replay");
        thread.start();
    }

    void addJournalListener(JournalListener listener) {
        this.listeners.add(listener);
    }

    void removeJournalListener(JournalListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyJournalStarted(boolean replay) {
        for (JournalListener listener : this.listeners) {
            listener.journalStarted(replay);
        }
    }

    private void notifyJournalEvent(boolean replay) {
        for (JournalListener listener : this.listeners) {
            listener.journalEvent(++this.eventCount, replay);
        }
    }

    private void notifyJournalEnded(boolean replay) {
        for (JournalListener listener : this.listeners) {
            listener.journalEnded(replay);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event == TapQueueControl.TapStartEvent) {
            this.notifyJournalStarted(false);
        } else if (event == TapQueueControl.TapEndEvent) {
            this.notifyJournalEnded(false);
        } else {
            this.addEvent((InputEvent)event);
            this.notifyJournalEvent(false);
        }
    }

    private void addEvent(InputEvent e) {
        if (e instanceof MouseWheelEvent) {
            this.addEvent((MouseWheelEvent)e);
        } else if (e instanceof KeyEvent) {
            this.addEvent((KeyEvent)e);
        } else if (e instanceof MouseEvent) {
            this.addEvent((MouseEvent)e);
        } else assert (false);
    }

    private void addEvent(MouseEvent e) {
        XmlNode node = this.doc.getRoot().addChild("MouseEvent");
        node.setAttribute("id", InputEventJournal.toString(e.getID()));
        node.setAttribute("when", InputEventJournal.toString(e.getWhen()));
        node.setAttribute("modifiers", InputEventJournal.toString(e.getModifiers()));
        node.setAttribute("x", InputEventJournal.toString(e.getX()));
        node.setAttribute("y", InputEventJournal.toString(e.getY()));
        node.setAttribute("clickCount", InputEventJournal.toString(e.getClickCount()));
        node.setAttribute("popup", InputEventJournal.toString(e.isPopupTrigger()));
        node.setAttribute("button", InputEventJournal.toString(e.getButton()));
    }

    private void addEvent(MouseWheelEvent e) {
        XmlNode node = this.doc.getRoot().addChild("MouseWheelEvent");
        node.setAttribute("id", InputEventJournal.toString(e.getID()));
        node.setAttribute("when", InputEventJournal.toString(e.getWhen()));
        node.setAttribute("modifiers", InputEventJournal.toString(e.getModifiers()));
        node.setAttribute("x", InputEventJournal.toString(e.getX()));
        node.setAttribute("y", InputEventJournal.toString(e.getY()));
        node.setAttribute("clickCount", InputEventJournal.toString(e.getClickCount()));
        node.setAttribute("popup", InputEventJournal.toString(e.isPopupTrigger()));
        node.setAttribute("type", InputEventJournal.toString(e.getScrollType()));
        node.setAttribute("amount", InputEventJournal.toString(e.getScrollAmount()));
        node.setAttribute("rotation", InputEventJournal.toString(e.getWheelRotation()));
    }

    private void addEvent(KeyEvent e) {
        XmlNode node = this.doc.getRoot().addChild("KeyEvent");
        node.setAttribute("id", InputEventJournal.toString(e.getID()));
        node.setAttribute("when", InputEventJournal.toString(e.getWhen()));
        node.setAttribute("modifiers", InputEventJournal.toString(e.getModifiers()));
        node.setAttribute("keyCode", InputEventJournal.toString(e.getKeyCode()));
        node.setAttribute("keyChar", InputEventJournal.toString(e.getKeyChar()));
        node.setAttribute("keyLoc", InputEventJournal.toString(e.getKeyLocation()));
    }

    private InputEvent createEvent(JFrame frame, XmlNode node) throws XMLException {
        String name = node.getName();
        if (name.equals("MouseEvent")) {
            return this.createMouseEvent(frame, node);
        }
        if (name.equals("MouseWheelEvent")) {
            return this.createMouseWheelEvent(frame, node);
        }
        if (name.equals("KeyEvent")) {
            return this.createKeyEvent(frame, node);
        }
        assert (false);
        return null;
    }

    private InputEvent createMouseEvent(JFrame frame, XmlNode node) throws XMLException {
        int id = InputEventJournal.parseInt(node.getAttribute("id"));
        long when = InputEventJournal.parseLong(node.getAttribute("when"));
        int modifiers = InputEventJournal.parseInt(node.getAttribute("modifiers"));
        int x = InputEventJournal.parseInt(node.getAttribute("x"));
        int y = InputEventJournal.parseInt(node.getAttribute("y"));
        int clickCount = InputEventJournal.parseInt(node.getAttribute("clickCount"));
        boolean popup = InputEventJournal.parseBoolean(node.getAttribute("popup"));
        int button = InputEventJournal.parseInt(node.getAttribute("button"));
        MouseEvent e = new MouseEvent(frame, id, when, modifiers, x, y, clickCount, popup, button);
        return e;
    }

    private InputEvent createMouseWheelEvent(JFrame frame, XmlNode node) throws XMLException {
        int id = InputEventJournal.parseInt(node.getAttribute("id"));
        long when = InputEventJournal.parseLong(node.getAttribute("when"));
        int modifiers = InputEventJournal.parseInt(node.getAttribute("modifiers"));
        int x = InputEventJournal.parseInt(node.getAttribute("x"));
        int y = InputEventJournal.parseInt(node.getAttribute("y"));
        int clickCount = InputEventJournal.parseInt(node.getAttribute("clickCount"));
        boolean popup = InputEventJournal.parseBoolean(node.getAttribute("popup"));
        int type = InputEventJournal.parseInt(node.getAttribute("type"));
        int amount = InputEventJournal.parseInt(node.getAttribute("amount"));
        int rotation = InputEventJournal.parseInt(node.getAttribute("rotation"));
        MouseWheelEvent e = new MouseWheelEvent((Component)frame, id, when, modifiers, x, y, clickCount, popup, type, amount, rotation);
        return e;
    }

    private InputEvent createKeyEvent(JFrame frame, XmlNode node) throws XMLException {
        int id = InputEventJournal.parseInt(node.getAttribute("id"));
        long when = InputEventJournal.parseLong(node.getAttribute("when"));
        int modifiers = InputEventJournal.parseInt(node.getAttribute("modifiers"));
        int keyCode = InputEventJournal.parseInt(node.getAttribute("keyCode"));
        char keyChar = InputEventJournal.parseChar(node.getAttribute("keyChar"));
        int keyLoc = InputEventJournal.parseInt(node.getAttribute("keyLoc"));
        KeyEvent e = new KeyEvent(frame, id, when, modifiers, keyCode, keyChar, keyLoc);
        return e;
    }

    private static String toString(char c) {
        return InputEventJournal.toString((int)c);
    }

    private static String toString(int i) {
        return Integer.toString(i);
    }

    private static String toString(long l) {
        return Long.toString(l);
    }

    private static String toString(boolean b) {
        return Boolean.toString(b);
    }

    private static char parseChar(String s) {
        return (char)InputEventJournal.parseInt(s);
    }

    private static int parseInt(String s) {
        return Integer.parseInt(s);
    }

    private static long parseLong(String s) {
        return Long.parseLong(s);
    }

    private static boolean parseBoolean(String s) {
        return Boolean.valueOf(s);
    }
}

