/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FadingContainer
extends JPanel {
    public static long Duration = 250L;
    public static int Steps = 10;
    private JComponent comp;
    private BufferedImage before;
    private BufferedImage after;
    private Thread animator;
    private float alpha;
    private ActionListener listener;

    public FadingContainer(Color background) {
        this(FadingContainer.createColorComponent(background));
    }

    public FadingContainer(JComponent comp) {
        this.comp = comp;
        this.setLayout(new BorderLayout());
        this.add(comp);
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public void nextComponent(JComponent next, ActionListener listener) {
        this.listener = listener;
        Dimension beforeSize = this.comp.getSize();
        if (beforeSize.width <= 0 || beforeSize.height <= 0) {
            this.remove(this.comp);
            this.comp = next;
            this.add(this.comp);
            this.validate();
            return;
        }
        this.before = new BufferedImage(beforeSize.width, beforeSize.height, 2);
        Graphics g = this.before.getGraphics();
        this.comp.paint(g);
        g.dispose();
        this.remove(this.comp);
        this.comp = next;
        this.alpha = 0.001f;
        this.add(this.comp);
        this.validate();
        Dimension afterSize = this.comp.getSize();
        if (afterSize.width <= 0 || afterSize.height <= 0) {
            return;
        }
        this.after = new BufferedImage(afterSize.width, afterSize.height, 2);
        g = this.after.getGraphics();
        this.comp.paint(g);
        g.dispose();
        this.listener = listener;
        this.startFade();
    }

    public void nextComponent(Color background, ActionListener listener) {
        JComponent backComp = FadingContainer.createColorComponent(background);
        this.nextComponent(backComp, listener);
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (this.alpha > 0.0f && this.alpha < 1.0f) {
            Graphics2D g = (Graphics2D)graphics;
            Composite oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.SrcAtop);
            g.drawRenderedImage(this.before, new AffineTransform());
            AlphaComposite blend = AlphaComposite.getInstance(10, this.alpha);
            g.setComposite(blend);
            g.drawRenderedImage(this.after, new AffineTransform());
            g.setComposite(oldComposite);
        } else {
            super.paintChildren(graphics);
        }
    }

    private void startFade() {
        this.animator = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int step = 1; step < Steps; ++step) {
                    try {
                        FadingContainer.this.alpha = (float)step / (float)Steps;
                        FadingContainer.this.repaint();
                        Thread.sleep(Duration / (long)Steps);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                FadingContainer.this.alpha = 1.0f;
                FadingContainer.this.repaint();
                if (FadingContainer.this.listener != null) {
                    FadingContainer.this.listener.actionPerformed(null);
                }
            }
        }, "FadingContainer");
        this.animator.start();
    }

    private static JComponent createColorComponent(final Color color) {
        JComponent comp = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                Dimension size = this.getSize();
                Color oldColor = g.getColor();
                g.setColor(color);
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(oldColor);
            }
        };
        return comp;
    }

    public static void main(String[] args) {
        final JLabel red = new JLabel("red");
        red.setBackground(Color.red);
        red.setOpaque(true);
        final JLabel green = new JLabel("green");
        green.setBackground(Color.green);
        green.setOpaque(true);
        final FadingContainer fader = new FadingContainer(Color.blue);
        JPanel content = new JPanel(new BorderLayout());
        content.add(fader);
        JButton redButton = new JButton("red");
        redButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                fader.nextComponent(red, null);
            }
        });
        JButton greenButton = new JButton("green");
        greenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                fader.nextComponent(green, null);
            }
        });
        JButton awayButton = new JButton("away");
        awayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                fader.nextComponent(Color.blue, null);
            }
        });
        Box buttons = Box.createVerticalBox();
        buttons.add(redButton);
        buttons.add(greenButton);
        buttons.add(awayButton);
        content.add((Component)buttons, "South");
        JFrame frame = new JFrame("Test");
        frame.setContentPane(content);
        frame.setDefaultCloseOperation(3);
        frame.setSize(200, 200);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

