/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.CompositeDescriptor;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.operation.OpActions;
import com.lightcrafts.ui.toolkit.ImageOnlyButton;
import com.lightcrafts.ui.toolkit.ShadowFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ButtonIcon
implements Icon {
    public static final Color UNSELECTED_COLOR = new Color(210, 210, 210);
    public static final Color PRESSED_COLOR = new Color(170, 170, 170);
    public static final Color SELECTED_COLOR = new Color(170, 170, 170);
    public static final Color DISABLED_COLOR = new Color(118, 118, 118);
    public static final int UNSELECTED = 0;
    public static final int SELECTED = 1;
    public static final int PRESSED = 2;
    public static final int DISABLED = 3;
    public static final int PLAIN_BUTTON = 0;
    public static final int LEFT_BUTTON = 1;
    public static final int RIGHT_BUTTON = 2;
    public static final int CENTER_BUTTON = 3;
    private static final boolean useResource = true;
    private static boolean isJava14 = System.getProperty("java.version").startsWith("1.4");
    private static boolean isOSXTiger = Platform.getType() == Platform.MacOSX && System.getProperty("os.version").startsWith("10.4");
    private static boolean isOSXPanther = Platform.getType() == Platform.MacOSX && System.getProperty("os.version").startsWith("10.3");
    private static BufferedImage leftPieceNormal;
    private static BufferedImage centerPieceNormal;
    private static BufferedImage rightPieceNormal;
    private static BufferedImage rightEdgeNormal;
    private static BufferedImage leftPiecePressed;
    private static BufferedImage centerPiecePressed;
    private static BufferedImage rightPiecePressed;
    private static BufferedImage rightEdgePressed;
    private static BufferedImage leftPieceSelected;
    private static BufferedImage centerPieceSelected;
    private static BufferedImage rightPieceSelected;
    private static BufferedImage rightEdgeSelected;
    private static BufferedImage leftPieceDisabled;
    private static BufferedImage centerPieceDisabled;
    private static BufferedImage rightPieceDisabled;
    private static BufferedImage rightEdgeDisabled;
    private int state;
    private BufferedImage image;
    static final float darkening = 0.85f;
    static final float litening = 1.03f;

    private static Color colorFromState(int state) {
        switch (state) {
            case 3: {
                return UNSELECTED_COLOR;
            }
            case 1: {
                return SELECTED_COLOR;
            }
            case 2: {
                return PRESSED_COLOR;
            }
            case 0: {
                return UNSELECTED_COLOR;
            }
        }
        throw new IllegalArgumentException("Bad Button State");
    }

    private static BufferedImage makeDisabled(BufferedImage image) {
        RescaleOp rescale1 = new RescaleOp(new float[]{0.75f, 0.75f, 0.75f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        float lightness = 0.3f;
        RescaleOp rescale2 = new RescaleOp(new float[]{1.0f - lightness, 1.0f - lightness, 1.0f - lightness, 1.0f}, new float[]{lightness * 255.0f, lightness * 255.0f, lightness * 255.0f, 0.0f}, null);
        return rescale2.filter(rescale1.filter(image, null), null);
    }

    ButtonIcon(int width, int state, int buttonType) {
        this.state = state;
        this.image = this.basicButton(width, 20, buttonType);
    }

    public ButtonIcon(BufferedImage icon, int state, int buttonType) {
        this(icon, 0, state, buttonType);
    }

    public ButtonIcon(BufferedImage icon, int width, int state, int buttonType) {
        this.state = state;
        this.image = this.iconButton(icon, width, buttonType);
    }

    public ButtonIcon(String text, int state, int buttonType) {
        this(text, 0, state, buttonType);
    }

    public ButtonIcon(String text, int width, int state, int buttonType) {
        this.state = state;
        this.image = this.textButton(text, width, buttonType);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ((Graphics2D)g).drawRenderedImage(this.image, AffineTransform.getTranslateInstance(x, y));
    }

    @Override
    public int getIconWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.image.getHeight();
    }

    static final Color multiply(Color color, float factor) {
        return new Color((int)((float)color.getRed() * factor), (int)((float)color.getGreen() * factor), (int)((float)color.getBlue() * factor));
    }

    BufferedImage basicButtonFromResouce(int sizeX, int sizeY, int buttonType) {
        BufferedImage rightEdge;
        BufferedImage rightPiece;
        BufferedImage centerPiece;
        BufferedImage leftPiece;
        sizeX += 6;
        sizeY += 7;
        if (buttonType != 0) {
            switch (buttonType) {
                case 1: {
                    sizeX += 3;
                    break;
                }
                case 3: {
                    sizeX += 5;
                    break;
                }
                case 2: {
                    sizeX += 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown button type: " + buttonType);
                }
            }
        }
        int width = sizeX;
        if (buttonType != 0) {
            switch (buttonType) {
                case 1: {
                    width -= 5;
                    break;
                }
                case 3: {
                    width -= 9;
                    break;
                }
                case 2: {
                    width -= 5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown button type: " + buttonType);
                }
            }
        }
        switch (this.state) {
            case 0: {
                leftPiece = leftPieceNormal;
                centerPiece = centerPieceNormal;
                rightPiece = rightPieceNormal;
                rightEdge = rightEdgeNormal;
                break;
            }
            case 1: {
                leftPiece = leftPieceSelected;
                centerPiece = centerPieceSelected;
                rightPiece = rightPieceSelected;
                rightEdge = rightEdgeSelected;
                break;
            }
            case 2: {
                leftPiece = leftPiecePressed;
                centerPiece = centerPiecePressed;
                rightPiece = rightPiecePressed;
                rightEdge = rightEdgePressed;
                break;
            }
            case 3: {
                leftPiece = leftPieceDisabled;
                centerPiece = centerPieceDisabled;
                rightPiece = rightPieceDisabled;
                rightEdge = rightEdgeDisabled;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad Button State");
            }
        }
        BufferedImage buttonTile = new BufferedImage(width, sizeY, 2);
        if (buttonType == 0 || buttonType == 1) {
            buttonTile.setData(leftPiece.getData());
        }
        int leftPadding = buttonType == 0 || buttonType == 1 ? 5 : 0;
        for (int i = 0; i <= sizeX - leftPadding - 5; ++i) {
            buttonTile.setData(centerPiece.getData().createTranslatedChild(i + leftPadding, 0));
        }
        if (buttonType == 1 || buttonType == 3) {
            buttonTile.setData(rightEdge.getData().createTranslatedChild(width - 1, 0));
        }
        if (buttonType == 0 || buttonType == 2) {
            buttonTile.setData(rightPiece.getData().createTranslatedChild(width - 5 + 1, 0));
        }
        return buttonTile;
    }

    public BufferedImage basicButton(int sizeX, int sizeY, int buttonType) {
        if (buttonType != 0) {
            switch (buttonType) {
                case 1: {
                    sizeX += 3;
                    break;
                }
                case 3: {
                    sizeX += 5;
                    break;
                }
                case 2: {
                    sizeX += 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown button type: " + buttonType);
                }
            }
        }
        BufferedImage buttonTile = new BufferedImage(sizeX + 1, sizeY + 1, 2);
        Color baseColor = ButtonIcon.colorFromState(this.state);
        Color rimColor = ButtonIcon.multiply(baseColor, 1.03f);
        Color rimColorDark = ButtonIcon.multiply(rimColor, 0.85f);
        Color baseColorDark = ButtonIcon.multiply(baseColor, 0.85f);
        Graphics2D g = (Graphics2D)buttonTile.getGraphics();
        g.setPaint(new GradientPaint(0.0f, 0.0f, rimColor, 0.0f, sizeY, rimColorDark));
        g.fillRoundRect(0, 0, sizeX, sizeY, 6, 6);
        g.setPaint(new GradientPaint(0.0f, 1.0f, baseColor, 0.0f, sizeY - 2, baseColorDark));
        g.fillRoundRect(1, 1, sizeX - 2, sizeY - 2, 6, 6);
        if (buttonType != 0) {
            Color baseColorDarker = ButtonIcon.multiply(baseColorDark, 0.85f);
            g.setPaint(null);
            g.setColor(baseColorDarker);
            switch (buttonType) {
                case 1: {
                    g.drawLine(sizeX - 2, 0, sizeX - 2, sizeY);
                    break;
                }
                case 3: {
                    g.drawLine(sizeX - 2, 0, sizeX - 2, sizeY);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown button type: " + buttonType);
                }
            }
        }
        g.dispose();
        if (this.state == 3) {
            buttonTile = ButtonIcon.makeDisabled(buttonTile);
        }
        ShadowFactory sf = new ShadowFactory(3, 0.8f, new Color(128, 128, 128));
        sf.setRenderingHint("blur_quality", "high");
        BufferedImage shadowedTile = sf.createShadow(buttonTile);
        g = (Graphics2D)shadowedTile.getGraphics();
        g.drawRenderedImage(buttonTile, AffineTransform.getTranslateInstance(3.0, 2.0));
        g.dispose();
        if (buttonType != 0) {
            Raster clipped;
            switch (buttonType) {
                case 1: {
                    clipped = shadowedTile.getData(new Rectangle(0, 0, shadowedTile.getWidth() - 5, shadowedTile.getHeight()));
                    break;
                }
                case 3: {
                    clipped = shadowedTile.getData(new Rectangle(5, 0, shadowedTile.getWidth() - 10, shadowedTile.getHeight())).createTranslatedChild(0, 0);
                    break;
                }
                case 2: {
                    clipped = shadowedTile.getData(new Rectangle(5, 0, shadowedTile.getWidth() - 5, shadowedTile.getHeight())).createTranslatedChild(0, 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown button type: " + buttonType);
                }
            }
            shadowedTile = new BufferedImage(shadowedTile.getColorModel(), (WritableRaster)clipped, false, null);
        }
        return shadowedTile;
    }

    public BufferedImage textButton(String text, int width, int buttonType) {
        Font font = new Font("Lucida Grande", 0, 12);
        TextLayout layout = new TextLayout(text, font, new FontRenderContext(null, true, true));
        Rectangle2D bounds = layout.getBounds();
        if (width == 0) {
            width = (int)bounds.getWidth() + 16;
        }
        int height = 20;
        BufferedImage buttonTile = this.basicButtonFromResouce(width, height, buttonType);
        Graphics2D g = (Graphics2D)buttonTile.getGraphics();
        if (this.state == 3) {
            g.setColor(Color.gray);
        } else {
            g.setColor(Color.BLACK);
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        float x = (float)((double)buttonTile.getWidth() / 2.0 - bounds.getWidth() / 2.0) + 1.0f;
        float y = (float)((double)buttonTile.getHeight() / 2.0 - bounds.getHeight() / 2.0) - 1.0f;
        if (!isOSXPanther) {
            layout.draw(g, x, y += layout.getAscent() - layout.getDescent());
        } else {
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            bounds = fm.getStringBounds(text, g);
            g.drawString(text, x, y += (float)fm.getAscent() - layout.getDescent());
        }
        boolean debug = false;
        if (debug) {
            g.drawRect((int)((double)x + bounds.getX() - 1.0), (int)((double)y + bounds.getY() - 1.0), (int)(bounds.getWidth() + 2.0), (int)(bounds.getHeight() + 2.0));
        }
        g.dispose();
        return buttonTile;
    }

    public BufferedImage iconButton(BufferedImage icon, int width, int buttonType) {
        BufferedImage adjustedIcon;
        if (this.state == 3) {
            icon = ButtonIcon.makeDisabled(icon);
        }
        int maxSize = 18;
        float scale = icon.getHeight() > maxSize ? (float)maxSize / (float)icon.getHeight() : 1.0f;
        if (width == -1) {
            width = Math.max(26, (int)(scale * (float)icon.getWidth()) + 14);
        } else if (width == 0) {
            width = Math.max(26, (int)(scale * (float)icon.getWidth()));
        }
        BufferedImage buttonTile = this.basicButtonFromResouce(width, 20, buttonType);
        RenderingHints extenderHint = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        Interpolation interp = Interpolation.getInstance((int)1);
        float x = (int)((float)buttonTile.getWidth() / 2.0f - scale * (float)icon.getWidth() / 2.0f + 0.5f);
        float y = (int)((float)buttonTile.getHeight() / 2.0f - scale * (float)icon.getHeight() / 2.0f - 0.5f);
        if (buttonType != 0) {
            switch (buttonType) {
                case 1: {
                    x += 1.0f;
                    break;
                }
                case 3: {
                    x -= 1.0f;
                    break;
                }
                case 2: {
                    x -= 2.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown button type: " + buttonType);
                }
            }
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
        if (scale != 1.0f) {
            float scaleX = (float)Math.floor(scale * (float)icon.getWidth()) / (float)icon.getWidth();
            float scaleY = (float)Math.floor(scale * (float)icon.getHeight()) / (float)icon.getHeight();
            transform.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
        }
        if (!isOSXTiger || !isJava14) {
            Graphics2D g = (Graphics2D)buttonTile.getGraphics();
            AffineTransformOp op = new AffineTransformOp(transform, 2);
            g.drawImage(icon, op, 0, 0);
            g.dispose();
            return buttonTile;
        }
        if (!transform.isIdentity()) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(icon);
            pb.add(transform);
            pb.add(interp);
            adjustedIcon = JAI.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)extenderHint);
        } else {
            adjustedIcon = icon;
        }
        ParameterBlock pb = new ParameterBlock();
        pb.add((float)buttonTile.getWidth());
        pb.add((float)buttonTile.getHeight());
        pb.add(new Byte[]{new Byte(0), new Byte(0), new Byte(0), new Byte(0)});
        RenderedOp zero = JAI.create((String)"Constant", (ParameterBlock)pb, null);
        RenderedOp extendedIcon = JAI.create((String)"Overlay", (RenderedImage)zero, (RenderedImage)adjustedIcon);
        BufferedImage allRGB = new BufferedImage(buttonTile.getWidth(), buttonTile.getHeight(), 5);
        allRGB.setData(buttonTile.getData().createChild(0, 0, buttonTile.getWidth(), buttonTile.getHeight(), 0, 0, new int[]{0, 1, 2}));
        BufferedImage allAlpha = new BufferedImage(buttonTile.getWidth(), buttonTile.getHeight(), 10);
        allAlpha.setData(buttonTile.getData().createChild(0, 0, buttonTile.getWidth(), buttonTile.getHeight(), 0, 0, new int[]{3}));
        BufferedImage iconRGB = new BufferedImage(extendedIcon.getWidth(), extendedIcon.getHeight(), 5);
        iconRGB.setData(extendedIcon.getData().createChild(0, 0, extendedIcon.getWidth(), extendedIcon.getHeight(), 0, 0, new int[]{0, 1, 2}));
        BufferedImage iconAlpha = new BufferedImage(extendedIcon.getWidth(), extendedIcon.getHeight(), 10);
        iconAlpha.setData(extendedIcon.getData().createChild(0, 0, extendedIcon.getWidth(), extendedIcon.getHeight(), 0, 0, new int[]{3}));
        pb = new ParameterBlock();
        pb.addSource(iconRGB);
        pb.addSource(allRGB);
        pb.add(iconAlpha);
        pb.add(allAlpha);
        pb.add(new Boolean(false));
        pb.add(CompositeDescriptor.DESTINATION_ALPHA_LAST);
        return JAI.create((String)"Composite", (ParameterBlock)pb, null).getAsBufferedImage();
    }

    public static void main(String[] args) throws Exception {
        new File("../../Buttons").mkdir();
        ButtonIcon buttonTile = new ButtonIcon(25, 0, 1);
        BufferedImage buttonImage = buttonTile.image;
        ImageIO.write((RenderedImage)buttonImage, "PNG", new File("../../Buttons/LeftButtonImage.png"));
        buttonTile = new ButtonIcon(25, 0, 2);
        buttonImage = buttonTile.image;
        ImageIO.write((RenderedImage)buttonImage, "PNG", new File("../../Buttons/RightButtonImage.png"));
        buttonTile = new ButtonIcon(25, 0, 3);
        buttonImage = buttonTile.image;
        ImageIO.write((RenderedImage)buttonImage, "PNG", new File("../../Buttons/CenterButtonImage.png"));
        buttonTile = new ButtonIcon(25, 0, 0);
        buttonImage = buttonTile.image;
        ImageIO.write((RenderedImage)buttonImage, "PNG", new File("../../Buttons/ButtonImage.png"));
        BufferedImage leftPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(0, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        BufferedImage rightPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 5, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        BufferedImage centerPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(5, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)leftPiece, "PNG", new File("../../Buttons/LeftPiece.png"));
        ImageIO.write((RenderedImage)rightPiece, "PNG", new File("../../Buttons/RightPiece.png"));
        ImageIO.write((RenderedImage)centerPiece, "PNG", new File("../../Buttons/CenterPiece.png"));
        buttonTile = new ButtonIcon(25, 0, 1);
        buttonImage = buttonTile.image;
        BufferedImage rightEdge = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 1, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)rightEdge, "PNG", new File("../../Buttons/RightEdge.png"));
        buttonTile = new ButtonIcon(25, 2, 0);
        buttonImage = buttonTile.image;
        leftPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(0, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        rightPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 5, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        centerPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(5, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)leftPiece, "PNG", new File("../../Buttons/LeftPiecePressed.png"));
        ImageIO.write((RenderedImage)rightPiece, "PNG", new File("../../Buttons/RightPiecePressed.png"));
        ImageIO.write((RenderedImage)centerPiece, "PNG", new File("../../Buttons/CenterPiecePressed.png"));
        buttonTile = new ButtonIcon(25, 2, 1);
        buttonImage = buttonTile.image;
        rightEdge = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 1, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)rightEdge, "PNG", new File("../../Buttons/RightEdgePressed.png"));
        buttonTile = new ButtonIcon(25, 1, 0);
        buttonImage = buttonTile.image;
        leftPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(0, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        rightPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 5, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        centerPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(5, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)leftPiece, "PNG", new File("../../Buttons/LeftPieceSelected.png"));
        ImageIO.write((RenderedImage)rightPiece, "PNG", new File("../../Buttons/RightPieceSelected.png"));
        ImageIO.write((RenderedImage)centerPiece, "PNG", new File("../../Buttons/CenterPieceSelected.png"));
        buttonTile = new ButtonIcon(25, 1, 1);
        buttonImage = buttonTile.image;
        rightEdge = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 1, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)rightEdge, "PNG", new File("../../Buttons/RightEdgeSelected.png"));
        buttonTile = new ButtonIcon(25, 3, 0);
        buttonImage = buttonTile.image;
        leftPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(0, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        rightPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 5, 0, 5, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        centerPiece = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(5, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)leftPiece, "PNG", new File("../../Buttons/LeftPieceDisabled.png"));
        ImageIO.write((RenderedImage)rightPiece, "PNG", new File("../../Buttons/RightPieceDisabled.png"));
        ImageIO.write((RenderedImage)centerPiece, "PNG", new File("../../Buttons/CenterPieceDisabled.png"));
        buttonTile = new ButtonIcon(25, 3, 1);
        buttonImage = buttonTile.image;
        rightEdge = new BufferedImage(buttonImage.getColorModel(), (WritableRaster)buttonImage.getData().createChild(buttonImage.getWidth() - 1, 0, 1, buttonImage.getHeight(), 0, 0, new int[]{0, 1, 2, 3}), false, null);
        ImageIO.write((RenderedImage)rightEdge, "PNG", new File("../../Buttons/RightEdgeDisabled.png"));
        BufferedImage icon = null;
        try {
            icon = ImageIO.read(OpActions.class.getResource("resources/hue_saturation.png"));
        }
        catch (Exception e) {
            // empty catch block
        }
        ImageOnlyButton button = new ImageOnlyButton(new ButtonIcon(icon, 0, 0), (Icon)new ButtonIcon(icon, 1, 0));
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setBackground(new Color(211, 211, 211));
        panel.add(button);
        frame.setContentPane(panel);
        frame.pack();
        frame.setSize(200, 200);
        frame.show();
    }

    static {
        try {
            leftPieceNormal = ImageIO.read(ButtonIcon.class.getResource("resources/LeftPiece.png"));
            centerPieceNormal = ImageIO.read(ButtonIcon.class.getResource("resources/CenterPiece.png"));
            rightPieceNormal = ImageIO.read(ButtonIcon.class.getResource("resources/RightPiece.png"));
            rightEdgeNormal = ImageIO.read(ButtonIcon.class.getResource("resources/RightEdge.png"));
            leftPiecePressed = ImageIO.read(ButtonIcon.class.getResource("resources/LeftPiecePressed.png"));
            centerPiecePressed = ImageIO.read(ButtonIcon.class.getResource("resources/CenterPiecePressed.png"));
            rightPiecePressed = ImageIO.read(ButtonIcon.class.getResource("resources/RightPiecePressed.png"));
            rightEdgePressed = ImageIO.read(ButtonIcon.class.getResource("resources/RightEdgePressed.png"));
            leftPieceSelected = ImageIO.read(ButtonIcon.class.getResource("resources/LeftPieceSelected.png"));
            centerPieceSelected = ImageIO.read(ButtonIcon.class.getResource("resources/CenterPieceSelected.png"));
            rightPieceSelected = ImageIO.read(ButtonIcon.class.getResource("resources/RightPieceSelected.png"));
            rightEdgeSelected = ImageIO.read(ButtonIcon.class.getResource("resources/RightEdgeSelected.png"));
            leftPieceDisabled = ImageIO.read(ButtonIcon.class.getResource("resources/LeftPieceDisabled.png"));
            centerPieceDisabled = ImageIO.read(ButtonIcon.class.getResource("resources/CenterPieceDisabled.png"));
            rightPieceDisabled = ImageIO.read(ButtonIcon.class.getResource("resources/RightPieceDisabled.png"));
            rightEdgeDisabled = ImageIO.read(ButtonIcon.class.getResource("resources/RightEdgeDisabled.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

