/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.ui.templates.TemplatePreview;
import com.lightcrafts.ui.templates.TemplateTree;
import com.lightcrafts.ui.templates.TemplateTreeNode;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TemplatePreviewMouseListener
extends MouseInputAdapter {
    private TemplateTree tree;
    private TemplatePreview preview;
    private TemplateTreeNode previewNode;

    TemplatePreviewMouseListener(TemplateTree tree, TemplatePreview preview) {
        this.tree = tree;
        this.preview = preview;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        TreePath path = this.tree.getPathForLocation(p.x, p.y);
        if (path != null) {
            Object last = path.getLastPathComponent();
            if (last instanceof TemplateTreeNode) {
                TemplateTreeNode node = (TemplateTreeNode)last;
                XmlNode xml = node.node;
                this.preview.showTemplatePreview(xml);
                this.setPreviewNode((TemplateTreeNode)last);
            } else {
                this.preview.showNormalPreview();
                this.setPreviewNode(null);
            }
        } else {
            this.preview.showNormalPreview();
            this.setPreviewNode(null);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.preview.showNormalPreview();
        this.setPreviewNode(null);
    }

    private void setPreviewNode(TemplateTreeNode node) {
        if (this.previewNode != null && this.previewNode != node) {
            this.previewNode.setPreviewed(false);
            this.repaintTreeNode(this.previewNode);
        }
        this.previewNode = node;
        if (this.previewNode != null) {
            this.previewNode.setPreviewed(true);
            this.repaintTreeNode(this.previewNode);
        }
    }

    private void repaintTreeNode(TreeNode node) {
        LinkedList<TreeNode> objects = new LinkedList<TreeNode>();
        while (node != null) {
            objects.addFirst(node);
            node = node.getParent();
        }
        TreePath path = new TreePath(objects.toArray());
        Rectangle rect = this.tree.getPathBounds(path);
        this.tree.repaint(rect);
    }
}

