/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.model.Engine;
import com.lightcrafts.model.EngineFactory;
import com.lightcrafts.model.Preview;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.EditorControls;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

class TemplatePreview
extends JPanel {
    private static final Dimension PreferredSize = new Dimension(240, 180);
    private Engine engine;
    private EditorControls editControls;
    private Engine editEngine;
    private XmlNode recentTemplate;
    private List<OpControl> tools;

    TemplatePreview() {
        this.setLayout(null);
        this.setPreferredSize(PreferredSize);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, TemplatePreview.PreferredSize.height));
        this.setMinimumSize(new Dimension(1, TemplatePreview.PreferredSize.height));
        this.tools = new LinkedList<OpControl>();
        this.setBackground(LightZoneSkin.Colors.NeutralGray);
    }

    TemplatePreview(Engine engine) {
        this();
        this.engine = engine;
        Preview preview = engine.getPreviews().iterator().next();
        this.add(preview);
    }

    void showNormalPreview() {
        if (this.editControls == null) {
            return;
        }
        this.disposeEditControls();
        Preview preview = this.engine.getPreviews().iterator().next();
        this.removeAll();
        this.add(preview);
        this.validate();
        this.repaint();
    }

    void showTemplatePreview(XmlNode node) {
        if (this.engine == null) {
            return;
        }
        if (this.editControls == null) {
            this.createEditControls();
            Component comp = this.editEngine.getComponent();
            this.removeAll();
            this.add(comp);
            this.validate();
            this.repaint();
        }
        if (node != this.recentTemplate) {
            this.editControls.removeControls(this.tools);
            try {
                this.tools = this.editControls.addControls(node);
            }
            catch (Throwable t) {
                System.err.println("Could not preview a template");
                t.printStackTrace();
            }
            this.recentTemplate = node;
        }
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Component comp = this.getComponents()[0];
        if (this.editControls != null) {
            int y;
            int x;
            this.editEngine.setScale(new Rectangle(0, 0, size.width, size.height));
            Dimension naturalSize = this.editEngine.getNaturalSize();
            double imageRatio = (double)naturalSize.width / (double)naturalSize.height;
            double containerRatio = (double)size.width / (double)size.height;
            if (imageRatio > containerRatio) {
                x = 0;
                y = (size.height - naturalSize.height) / 2;
            } else {
                x = (size.width - naturalSize.width) / 2;
                y = 0;
            }
            comp.setSize(naturalSize);
            comp.setLocation(x, y);
        } else {
            comp.setLocation(0, 0);
            comp.setSize(size);
        }
    }

    private void createEditControls() {
        Dimension size = this.getSize();
        RenderedImage image = this.engine.getRendering(size);
        this.editEngine = EngineFactory.createEngine(image);
        this.editControls = new EditorControls(this.editEngine);
    }

    private void disposeEditControls() {
        this.editEngine.dispose();
        this.editControls = null;
        this.tools.clear();
        this.recentTemplate = null;
    }
}

