/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.swing;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.ui.swing.CommonRangeSelectorTrack;
import com.lightcrafts.ui.swing.RangeSelector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class RangeSelectorZoneTrack
extends CommonRangeSelectorTrack
implements RangeSelector.Track {
    private static final int ZONES = 16;

    @Override
    public void paintTrack(RangeSelector selector, Rectangle r, Graphics2D g2d) {
        int w = r.width - 2;
        int h = r.height - 2;
        int y = r.y + 1;
        float zoneWidth = (float)w / 16.0f;
        float[] colorArray = new float[3];
        Rectangle2D.Float r2d = new Rectangle2D.Float();
        for (int z = 0; z < 16; ++z) {
            float[] c = RangeSelectorZoneTrack.zoneToColor(z, colorArray);
            g2d.setColor(new Color(c[0], c[1], c[2]));
            float x = (float)(r.x + 1) + (float)z * zoneWidth;
            ((Rectangle2D)r2d).setRect(x, y, zoneWidth, h);
            g2d.fill(r2d);
        }
        RangeSelectorZoneTrack.paintBorder(r, g2d);
    }

    public static float[] zoneToColor(int zone, float[] rgb) {
        float c;
        assert (zone >= 0 && zone < 16);
        if (rgb == null) {
            rgb = new float[3];
        }
        rgb[1] = rgb[2] = (c = (float)((Math.pow(2.0, (double)zone * 8.0 / 15.0) - 1.0) / 255.0));
        rgb[0] = rgb[2];
        return Functions.fromLinearToCS(JAIContext.systemColorSpace, rgb);
    }
}

