/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.scroll;

import com.lightcrafts.ui.mode.AbstractMode;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class ScrollMode
extends AbstractMode {
    static Cursor OpenHand;
    static Cursor ClosedHand;
    private JScrollPane scroll;
    private JPanel overlay;

    public ScrollMode(JScrollPane scroll) {
        this.scroll = scroll;
        this.overlay = new JPanel();
        ScrollListener listener = new ScrollListener();
        this.overlay.setCursor(OpenHand);
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    @Override
    public JComponent getOverlay() {
        return this.overlay;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.overlay.removeMouseListener(listener);
        this.overlay.removeMouseMotionListener(listener);
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point hot = new Point(8, 8);
        String path = "resources/OpenHand.png";
        URL url = ScrollMode.class.getResource(path);
        Image image = toolkit.createImage(url);
        OpenHand = toolkit.createCustomCursor(image, hot, "Pan");
        path = "resources/ClosedHand.png";
        url = ScrollMode.class.getResource(path);
        image = toolkit.createImage(url);
        ClosedHand = toolkit.createCustomCursor(image, hot, "Panning");
    }

    private class ScrollListener
    extends MouseInputAdapter {
        private Point cursorStart;
        private Point viewportStart;

        private ScrollListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ScrollMode.this.overlay.setCursor(ClosedHand);
            e = SwingUtilities.convertMouseEvent(e.getComponent(), e, ScrollMode.this.scroll);
            this.cursorStart = e.getPoint();
            this.viewportStart = ScrollMode.this.scroll.getViewport().getViewPosition();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ScrollMode.this.overlay.setCursor(OpenHand);
            this.cursorStart = null;
            this.viewportStart = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            e = SwingUtilities.convertMouseEvent(e.getComponent(), e, ScrollMode.this.scroll);
            Point cursor = e.getPoint();
            int dx = cursor.x - this.cursorStart.x;
            int dy = cursor.y - this.cursorStart.y;
            Point q = new Point(this.viewportStart.x - dx, this.viewportStart.y - dy);
            JViewport viewport = ScrollMode.this.scroll.getViewport();
            Dimension viewSize = viewport.getViewSize();
            Dimension extentSize = viewport.getExtentSize();
            if (q.x < 0) {
                q.x = 0;
            } else if (extentSize.width >= viewSize.width) {
                q.x = 0;
            } else if (q.x > viewSize.width - extentSize.width) {
                q.x = viewSize.width - extentSize.width;
            }
            if (q.y < 0) {
                q.y = 0;
            } else if (extentSize.height >= viewSize.height) {
                q.y = 0;
            } else if (q.y > viewSize.height - extentSize.height) {
                q.y = viewSize.height - extentSize.height;
            }
            viewport.setViewPosition(q);
        }
    }
}

