/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.scroll;

import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;

class ImageScrollable
extends JPanel
implements Scrollable {
    private static final double UnitFraction = 0.01;
    private static final double BlockFraction = 1.0;
    private JComponent image;
    private final Color backgroundColor = LightZoneSkin.Colors.EditorBackground;

    ImageScrollable(JComponent image) {
        this.image = image;
        this.setLayout(null);
        this.setBackground(this.backgroundColor);
        this.add(image);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.image.getPreferredSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.image.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getIncrement(visibleRect, orientation, 0.01);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getIncrement(visibleRect, orientation, 1.0);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        JViewport viewport = (JViewport)this.getParent();
        Rectangle visible = viewport.getVisibleRect();
        return visible.width > this.image.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        JViewport viewport = (JViewport)this.getParent();
        Rectangle visible = viewport.getVisibleRect();
        return visible.height > this.image.getPreferredSize().height;
    }

    private int getIncrement(Rectangle visibleRect, int orientation, double x) {
        switch (orientation) {
            case 0: {
                return (int)Math.round((double)visibleRect.width * x);
            }
            case 1: {
                return (int)Math.round((double)visibleRect.height * x);
            }
        }
        return 0;
    }

    @Override
    public void doLayout() {
        int h;
        int y;
        int w;
        int x;
        Dimension size = this.getSize();
        Dimension imageSize = this.image.getPreferredSize();
        if (size.width >= imageSize.width) {
            x = (size.width - imageSize.width) / 2;
            w = imageSize.width;
        } else {
            x = 0;
            w = size.width;
        }
        if (size.height >= imageSize.height) {
            y = (size.height - imageSize.height) / 2;
            h = imageSize.height;
        } else {
            y = 0;
            h = size.height;
        }
        this.image.setBounds(x, y, w, h);
    }
}

