/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.scroll;

import com.lightcrafts.ui.scroll.CenteringViewport;
import com.lightcrafts.ui.scroll.CenteringViewportLayout;
import com.lightcrafts.ui.scroll.FooterScrollPaneLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;

public class CenteringScrollPane
extends JScrollPane {
    private JComponent footer;

    public CenteringScrollPane() {
        this(new JPanel());
    }

    public CenteringScrollPane(JComponent view) {
        CenteringViewport viewport = new CenteringViewport();
        viewport.setView(view);
        this.setViewport(viewport);
    }

    public CenteringScrollPane(JComponent view, JComponent footer) {
        this(view);
        FooterScrollPaneLayout layout = new FooterScrollPaneLayout();
        layout.setFooter(footer);
        this.setLayout(layout);
        this.add(footer);
        this.footer = footer;
    }

    public void setFooter(JComponent footer) {
        if (this.footer != null) {
            this.remove(this.footer);
            this.setLayout(new ScrollPaneLayout());
            this.footer = null;
        }
        if (footer != null) {
            this.add(footer);
            FooterScrollPaneLayout layout = new FooterScrollPaneLayout();
            this.setLayout(layout);
            layout.setFooter(footer);
            this.footer = footer;
        }
        this.repaint();
    }

    public void setCenteringLayout(boolean on) {
        CenteringViewport viewport = (CenteringViewport)this.getViewport();
        LayoutManager layout = viewport.getLayout();
        boolean isCentering = layout instanceof CenteringViewportLayout;
        if (on) {
            if (!isCentering) {
                layout = viewport.createCenteringLayoutManager();
                viewport.setLayout(layout);
            }
        } else if (isCentering) {
            layout = viewport.createDefaultLayoutManager();
            viewport.setLayout(layout);
        }
    }
}

