/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.rotate;

import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.rotate.MajorRotorSlider;
import com.lightcrafts.ui.rotate.MinorRotorSlider;
import com.lightcrafts.ui.rotate.ResetButton;
import com.lightcrafts.ui.rotate.RotateLeftAction;
import com.lightcrafts.ui.rotate.RotateRightAction;
import com.lightcrafts.ui.rotate.RotorListener;
import com.lightcrafts.ui.rotate.RotorMode;
import com.lightcrafts.ui.rotate.RotorTextField;
import com.lightcrafts.ui.toolkit.CoolButton;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;

public final class RotorControl
extends Box
implements RotorListener {
    private static final Icon RightUnselectedIcon = RotorMode.getIcon("rotRight_U");
    private static final Icon LeftUnselectedIcon = RotorMode.getIcon("rotLeft_U");
    private Box sliders;
    private MajorRotorSlider major = new MajorRotorSlider();
    private MinorRotorSlider minor = new MinorRotorSlider();
    private RotorTextField text;
    private CoolButton rightButton;
    private CoolButton leftButton;
    private ResetButton reset;
    private LinkedList<RotorListener> listeners;
    private double coarseAngle;
    private RotateLeftAction leftAction;
    private RotateRightAction rightAction;

    RotorControl() {
        super(0);
        this.sliders = Box.createVerticalBox();
        this.sliders.add(this.major);
        this.text = new RotorTextField(this);
        this.major.setFocusable(false);
        this.minor.setFocusable(false);
        MouseAdapter focusListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                RotorControl.this.text.requestFocusInWindow();
            }
        };
        this.major.addMouseListener(focusListener);
        this.minor.addMouseListener(focusListener);
        this.text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                RotorControl.this.major.addMouseWheelListener(RotorControl.this.text);
                RotorControl.this.minor.addMouseWheelListener(RotorControl.this.text);
            }

            @Override
            public void focusLost(FocusEvent event) {
                RotorControl.this.major.removeMouseWheelListener(RotorControl.this.text);
                RotorControl.this.minor.removeMouseWheelListener(RotorControl.this.text);
            }
        });
        this.add(this.sliders);
        this.listeners = new LinkedList();
        this.major.addRotorListener(this);
        this.minor.addRotorListener(this);
        this.reset = new ResetButton(this);
        this.leftAction = new RotateLeftAction(this);
        this.rightAction = new RotateRightAction(this);
        this.leftButton = new CoolButton();
        this.leftButton.setStyle(CoolButton.ButtonStyle.LEFT);
        this.leftButton.setAction(this.leftAction);
        this.leftButton.setIcon(LeftUnselectedIcon);
        this.rightButton = new CoolButton();
        this.rightButton.setStyle(CoolButton.ButtonStyle.RIGHT);
        this.rightButton.setAction(this.rightAction);
        this.rightButton.setIcon(RightUnselectedIcon);
        this.add(this.leftButton);
        this.add(this.rightButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.text);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.reset);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.sliders.setBackground(color);
        this.major.setBackground(color);
        this.minor.setBackground(color);
        this.rightButton.setBackground(color);
        this.leftButton.setBackground(color);
        this.reset.setBackground(color);
    }

    public void addRotorListener(RotorListener listener) {
        this.listeners.add(listener);
    }

    public void removeRotorListener(RotorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void angleChanged(double angle, boolean isChanging, boolean isNinetyDegrees) {
        this.text.update();
        this.notifyListeners(isChanging);
    }

    @Override
    public void angleReset() {
        this.angleChanged(0.0, false, false);
    }

    public double getAngle() {
        double fine = this.major.getAngle();
        double hyperFine = this.minor.getAngle();
        return this.coarseAngle + fine + hyperFine;
    }

    public void setAngle(double angle) {
        this.setAngleInternal(angle);
        this.notifyListeners(false);
    }

    void setAngleInternal(double angle) {
        int n = (int)Math.round(angle / 1.5707963267948966);
        this.coarseAngle = (double)n * 1.5707963267948966;
        double remainder = this.major.setAngle(angle - this.coarseAngle);
        this.minor.setAngle(remainder);
        this.text.update();
    }

    public Action getLeftAction() {
        return this.leftAction;
    }

    public Action getRightAction() {
        return this.rightAction;
    }

    double getDegrees() {
        double angle = this.getAngle();
        return RotorControl.radiansToDegrees(angle);
    }

    void setDegrees(double degrees) {
        double angle = RotorControl.degreesToRadians(degrees);
        int n = (int)Math.round(angle / Math.PI / 2.0);
        this.coarseAngle = (double)n * 1.5707963267948966;
        double remainder = this.major.setAngle(angle - this.coarseAngle);
        this.minor.setAngle(remainder);
        this.notifyListeners(false);
    }

    void incAngle(double delta) {
        double angle = this.getAngle();
        this.setAngleInternal(angle += delta);
        this.notifyListeners(false);
    }

    void notifyListeners(boolean isChanging) {
        double angle = this.getAngle();
        for (RotorListener listener : this.listeners) {
            listener.angleChanged(angle, isChanging, false);
        }
    }

    void notifyListenersNinetyDegrees() {
        double angle = this.getAngle();
        for (RotorListener listener : this.listeners) {
            listener.angleChanged(angle, false, true);
        }
    }

    void notifyListenersReset() {
        for (RotorListener listener : this.listeners) {
            listener.angleReset();
        }
    }

    static double degreesToRadians(double degrees) {
        return Math.PI * degrees / 180.0;
    }

    static double radiansToDegrees(double radians) {
        return 180.0 * radians / Math.PI;
    }

    public void setEditor(Editor editor) {
        this.leftAction.setEditor(editor);
        this.rightAction.setEditor(editor);
    }
}

