/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.rotate;

import com.lightcrafts.ui.rotate.Locale;
import com.lightcrafts.ui.rotate.RotorControl;
import com.lightcrafts.ui.rotate.RotorListener;
import com.lightcrafts.ui.toolkit.LCSliderUI;
import java.awt.Font;
import java.util.LinkedList;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MajorRotorSlider
extends JSlider
implements ChangeListener {
    private LinkedList<RotorListener> listeners;
    private boolean restoring;

    MajorRotorSlider() {
        super(-45, 45);
        this.setUI(new LCSliderUI(this));
        this.setToolTipText(Locale.LOCALE.get("MajorRotorToolTip"));
        this.setMajorTickSpacing(45);
        this.setMinorTickSpacing(15);
        this.setPaintTicks(true);
        this.setFont(new Font("Lucida Grande", 0, 9));
        this.addChangeListener(this);
        this.listeners = new LinkedList();
    }

    double getAngle() {
        int value = this.getValue();
        double angle = RotorControl.degreesToRadians(value);
        return angle;
    }

    double setAngle(double angle) {
        int value = (int)Math.round(RotorControl.radiansToDegrees(angle));
        this.restoring = true;
        this.setValue(value);
        this.restoring = false;
        double remainder = angle - this.getAngle();
        return remainder;
    }

    int getDegrees() {
        return this.getValue();
    }

    double setDegrees(double degrees) {
        double radians = RotorControl.degreesToRadians(degrees);
        double radianRemainder = this.setAngle(radians);
        double degreeRemainder = RotorControl.radiansToDegrees(radianRemainder);
        return degreeRemainder;
    }

    void addRotorListener(RotorListener listener) {
        this.listeners.add(listener);
    }

    void removeRotorListener(RotorListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(double angle, boolean isChanging) {
        for (RotorListener listener : this.listeners) {
            listener.angleChanged(angle, isChanging, false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (!this.restoring) {
            double angle = this.getAngle();
            boolean isChanging = this.getValueIsAdjusting();
            this.notifyListeners(angle, isChanging);
        }
    }
}

