/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.rotate;

import com.lightcrafts.ui.rotate.InfiniteLine;
import com.lightcrafts.ui.rotate.RotorControl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

class GridComponent
extends JComponent {
    private static Cursor RotateCursor = new Cursor(1);
    private static Color GridColor = new Color(55, 55, 55, 85);
    private static Stroke BlackStroke;
    private static Stroke WhiteStroke;
    private static int MinDragDistance;
    private RotorControl control;
    private Line2D line;
    private double angle = 0.0;
    private double spacing = 10.0;
    private boolean showGrid = true;

    GridComponent(RotorControl control) {
        this.control = control;
        this.setCursor(RotateCursor);
        LineListener listener = new LineListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    void setShowGrid(boolean show) {
        if (this.showGrid != show) {
            this.showGrid = show;
            this.repaint();
        }
    }

    void setAngle(double angle) {
        this.angle = angle;
        this.repaint();
    }

    void setSpacing(double spacing) {
        if (spacing >= 1.0) {
            this.spacing = spacing;
            this.repaint();
        }
    }

    private boolean isMinimumDragLength() {
        double dx = this.line.getX2() - this.line.getX1();
        double dy = this.line.getY2() - this.line.getY1();
        return Math.abs(dx) >= (double)MinDragDistance || Math.abs(dy) >= (double)MinDragDistance;
    }

    private double getLineAngle() {
        double dx = this.line.getX2() - this.line.getX1();
        double dy = this.line.getY2() - this.line.getY1();
        return Math.atan(dy / dx);
    }

    private double getDeltaAngle() {
        double lineAngle = this.getLineAngle();
        int n = (int)Math.round(lineAngle / 1.5707963267948966);
        double nearestRightAngle = (double)n * Math.PI / 2.0;
        return lineAngle - nearestRightAngle;
    }

    private void doRotate() {
        if (this.isMinimumDragLength()) {
            double delta = this.getDeltaAngle();
            this.control.incAngle(-delta);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        RenderingHints oldHints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        if (this.line != null) {
            GridComponent.drawDashedShape(g, this.line);
            if (this.isMinimumDragLength()) {
                double angle = this.getLineAngle();
                if (Math.cos(angle) * (this.line.getX2() - this.line.getX1()) < 0.0) {
                    angle -= Math.PI;
                }
                int n = (int)Math.round(angle / 1.5707963267948966);
                double axisAngle = (double)n * 1.5707963267948966;
                double x1 = this.line.getX1();
                double y1 = this.line.getY1();
                double x2 = this.line.getX2();
                double y2 = this.line.getY2();
                double r = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                Arc2D arc = GridComponent.createArc(x1, y1, r, angle, axisAngle);
                GridComponent.drawDashedShape(g, arc);
            }
        }
        if (this.showGrid) {
            double y;
            double x;
            InfiniteLine line;
            Line2D l;
            g.setColor(GridColor);
            Dimension size = this.getSize();
            int w = size.width;
            int h = size.height;
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, w, h);
            double midX = (double)w / 2.0;
            double midY = (double)h / 2.0;
            double normal = this.angle + 1.5707963267948966;
            int n = 0;
            do {
                if ((l = (line = new InfiniteLine(x = midX + (double)n * this.spacing * Math.cos(normal), y = midY + (double)n * this.spacing * Math.sin(normal), this.angle)).getSegment(bounds)) != null) {
                    g.draw(l);
                }
                ++n;
            } while (l != null);
            n = 0;
            do {
                if ((l = (line = new InfiniteLine(x = midX - (double)n * this.spacing * Math.cos(normal), y = midY - (double)n * this.spacing * Math.sin(normal), this.angle)).getSegment(bounds)) != null) {
                    g.draw(l);
                }
                ++n;
            } while (l != null);
            n = 0;
            do {
                if ((l = (line = new InfiniteLine(x = midX + (double)n * this.spacing * Math.cos(this.angle), y = midY + (double)n * this.spacing * Math.sin(this.angle), normal)).getSegment(bounds)) != null) {
                    g.draw(l);
                }
                ++n;
            } while (l != null);
            n = 0;
            do {
                if ((l = (line = new InfiniteLine(x = midX - (double)n * this.spacing * Math.cos(this.angle), y = midY - (double)n * this.spacing * Math.sin(this.angle), normal)).getSegment(bounds)) != null) {
                    g.draw(l);
                }
                ++n;
            } while (l != null);
        }
        g.setStroke(oldStroke);
        g.setColor(oldColor);
        g.setRenderingHints(oldHints);
    }

    private static void drawDashedShape(Graphics2D g, Shape shape) {
        g.setStroke(WhiteStroke);
        g.setColor(Color.white);
        g.draw(shape);
        g.setStroke(BlackStroke);
        g.setColor(Color.black);
        g.draw(shape);
    }

    private static Arc2D createArc(double cx, double cy, double r, double start, double end) {
        start = -RotorControl.radiansToDegrees(start);
        end = -RotorControl.radiansToDegrees(end);
        Arc2D.Double arc = new Arc2D.Double(cx - r, cy - r, 2.0 * r, 2.0 * r, start, end - start, 2);
        return arc;
    }

    static {
        MinDragDistance = 10;
        float[] dash = new float[]{5.0f, 5.0f};
        float width = 1.0f;
        BlackStroke = new BasicStroke(width, 1, 0, 1.0f, dash, 0.0f);
        WhiteStroke = new BasicStroke(width);
    }

    private class LineListener
    extends MouseInputAdapter {
        private Point start;

        private LineListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (GridComponent.this.line != null) {
                GridComponent.this.doRotate();
            }
            this.start = null;
            GridComponent.this.line = null;
            GridComponent.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point end = e.getPoint();
            GridComponent.this.line = new Line2D.Float(this.start.x, this.start.y, end.x, end.y);
            GridComponent.this.repaint();
        }
    }
}

