/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.Cubic;
import com.lightcrafts.ui.region.curves.Linear;
import com.lightcrafts.ui.region.curves.Quadratic;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;

class Polynomial {
    private ArrayList coefs = new ArrayList();

    Polynomial(double a) {
        this.coefs.add(new Double(a));
    }

    Polynomial(double a, double b) {
        this(a);
        this.coefs.add(new Double(b));
    }

    Polynomial(double a, double b, double c) {
        this(a, b);
        this.coefs.add(new Double(c));
    }

    Polynomial(double a, double b, double c, double d) {
        this(a, b, c);
        this.coefs.add(new Double(d));
    }

    Polynomial(ArrayList coefs) {
        this.coefs.addAll(coefs);
    }

    int getDegree() {
        return this.coefs.size() - 1;
    }

    double getCoeff(int i) {
        return (Double)this.coefs.get(i);
    }

    Polynomial add(Polynomial poly) {
        double y;
        ArrayList<Double> newCoefs = new ArrayList<Double>();
        int n = 0;
        while (n <= Math.min(this.getDegree(), poly.getDegree())) {
            double x = this.getCoeff(n);
            double y2 = poly.getCoeff(n++);
            newCoefs.add(new Double(x + y2));
        }
        while (n <= this.getDegree()) {
            y = this.getCoeff(n++);
            newCoefs.add(new Double(y));
        }
        while (n <= poly.getDegree()) {
            y = poly.getCoeff(n++);
            newCoefs.add(new Double(y));
        }
        return new Polynomial(newCoefs);
    }

    Polynomial multiply(double x) {
        ArrayList<Double> newCoefs = new ArrayList<Double>();
        int n = 0;
        while (n < this.coefs.size()) {
            double c = this.getCoeff(n++);
            newCoefs.add(new Double(c * x));
        }
        return new Polynomial(newCoefs);
    }

    Polynomial divide(double x) {
        return this.multiply(1.0 / x);
    }

    Polynomial translate(double dt) {
        Polynomial p;
        int degree = this.getDegree();
        switch (degree) {
            case 0: {
                return this;
            }
            case 1: {
                p = new Linear(this.getCoeff(0), this.getCoeff(1));
                break;
            }
            case 2: {
                p = new Quadratic(this.getCoeff(0), this.getCoeff(1), this.getCoeff(2));
                break;
            }
            case 3: {
                p = new Cubic(this.getCoeff(0), this.getCoeff(1), this.getCoeff(2), this.getCoeff(3));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported degree");
            }
        }
        p = ((Polynomial)p).translate(dt);
        return p;
    }

    double evaluate(double t) {
        double sum = 0.0;
        double x = 1.0;
        for (int n = 0; n < this.coefs.size(); ++n) {
            double c = this.getCoeff(n);
            sum += c * x;
            x *= t;
        }
        return sum;
    }

    static Shape createShape(Polynomial p1, Polynomial p2) {
        if (p1.getDegree() != p2.getDegree()) {
            throw new IllegalArgumentException("Mismatched degrees");
        }
        int degree = p1.getDegree();
        switch (degree) {
            case 0: {
                throw new IllegalArgumentException("Unsupported degree");
            }
            case 1: {
                return Linear.createShape(p1, p2);
            }
            case 2: {
                return Quadratic.createShape(p1, p2);
            }
            case 3: {
                return Cubic.createShape(p1, p2);
            }
        }
        throw new IllegalArgumentException("Unsupported degree");
    }

    static Shape createRationalShape(Polynomial xNum, Polynomial xDen, Polynomial yNum, Polynomial yDen, double start, double end, double inc) {
        double oldX = xNum.evaluate(start) / xDen.evaluate(start);
        double oldY = yNum.evaluate(start) / yDen.evaluate(start);
        GeneralPath path = new GeneralPath();
        for (double t = start; t <= end; t += inc) {
            double newX = xNum.evaluate(t) / xDen.evaluate(t);
            double newY = yNum.evaluate(t) / yDen.evaluate(t);
            Line2D.Double line = new Line2D.Double(oldX, oldY, newX, newY);
            path.append(line, true);
            oldX = newX;
            oldY = newY;
        }
        return path;
    }
}

