/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.BasisFunction;
import com.lightcrafts.ui.region.curves.CubicBasisSpline;
import com.lightcrafts.ui.region.curves.Polynomial;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class CubicRationalSpline
extends CubicBasisSpline {
    private static final double Weight = 1.0;

    @Override
    void updateShape() {
        if (this.points.size() < 2) {
            this.shape = null;
            this.segments.clear();
            return;
        }
        ArrayList extraPoints = new ArrayList(this.points);
        extraPoints.add(0, this.points.get(this.points.size() - 2));
        extraPoints.add(1, this.points.get(this.points.size() - 1));
        extraPoints.add(this.points.get(0));
        extraPoints.add(this.points.get(1));
        Object first = extraPoints.get(0);
        extraPoints.remove(0);
        extraPoints.add(first);
        GeneralPath path = new GeneralPath();
        int m = extraPoints.size();
        CubicRationalSpline.ensureBases(m);
        this.segments.clear();
        for (int i = 3; i < m - 1; ++i) {
            Polynomial xNum = new Polynomial(0.0);
            Polynomial yNum = new Polynomial(0.0);
            Polynomial xDen = new Polynomial(0.0);
            Polynomial yDen = new Polynomial(0.0);
            for (int j = 0; j < m; ++j) {
                Point2D p = (Point2D)extraPoints.get(j);
                BasisFunction basis = (BasisFunction)Bases.get(j);
                double px = p.getX();
                double py = p.getY();
                Polynomial xSegNum = basis.getSegment(i).multiply(px * 1.0);
                Polynomial ySegNum = basis.getSegment(i).multiply(py * 1.0);
                Polynomial xSegDen = basis.getSegment(i).multiply(1.0);
                Polynomial ySegDen = basis.getSegment(i).multiply(1.0);
                xNum = xNum.add(xSegNum);
                yNum = yNum.add(ySegNum);
                xDen = xDen.add(xSegDen);
                yDen = yDen.add(ySegDen);
            }
            Shape curve = Polynomial.createRationalShape(xNum, xDen, yNum, yDen, i, i + 1, 0.1);
            this.segments.add(curve);
            path.append(curve, true);
        }
        path.closePath();
        this.shape = path;
    }
}

