/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.Polynomial;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;

class Cubic
extends Polynomial {
    private double a;
    private double b;
    private double c;
    private double d;

    static Cubic createFactored(double z0, double z1, double z2) {
        return new Cubic(-z0 * z1 * z2, z0 * z1 + z1 * z2 + z2 * z0, -z0 - z1 - z2, 1.0);
    }

    Cubic(double a, double b, double c, double d) {
        super(a, b, c, d);
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    @Override
    Polynomial translate(double x) {
        return new Cubic(this.a + this.b * x + this.c * x * x + this.d * x * x * x, this.b + 2.0 * this.c * x + 3.0 * this.d * x * x, this.c + 3.0 * this.d * x, this.d);
    }

    static Shape createShape(Polynomial x, Polynomial y) {
        if (x.getDegree() != 3 || y.getDegree() != 3) {
            throw new IllegalArgumentException("Expected degree 3");
        }
        double xa = x.getCoeff(0);
        double xb = x.getCoeff(1);
        double xc = x.getCoeff(2);
        double xd = x.getCoeff(3);
        double ya = y.getCoeff(0);
        double yb = y.getCoeff(1);
        double yc = y.getCoeff(2);
        double yd = y.getCoeff(3);
        Point2D.Double p1 = new Point2D.Double(xa, ya);
        Point2D.Double cp1 = new Point2D.Double((3.0 * xa + xb) / 3.0, (3.0 * ya + yb) / 3.0);
        Point2D.Double cp2 = new Point2D.Double((3.0 * xa + 2.0 * xb + xc) / 3.0, (3.0 * ya + 2.0 * yb + yc) / 3.0);
        Point2D.Double p2 = new Point2D.Double(xa + xb + xc + xd, ya + yb + yc + yd);
        return new CubicCurve2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)cp1).getX(), ((Point2D)cp1).getY(), ((Point2D)cp2).getX(), ((Point2D)cp2).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY());
    }
}

