/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.Polynomial;
import java.util.ArrayList;

abstract class BasisFunction {
    private int i;
    private int p;
    private ArrayList polys;

    BasisFunction(int i, int p) {
        this.i = i;
        this.p = p;
        this.polys = new ArrayList();
        for (int n = i; n <= i + p; ++n) {
            Polynomial poly = this.computeSegment(n);
            this.polys.add(poly);
        }
    }

    int getFirstIndex() {
        return this.i;
    }

    int getLastIndex() {
        return this.i + this.p;
    }

    boolean isSupportedIndex(int j) {
        return j >= this.getFirstIndex() && j <= this.getLastIndex();
    }

    Polynomial getSegment(int n) {
        if (n >= this.i && n <= this.i + this.p) {
            return (Polynomial)this.polys.get(n - this.i);
        }
        return new Polynomial(0.0);
    }

    double evaluate(double t) {
        int j = (int)Math.floor(t);
        Polynomial p = this.getSegment(j);
        return p.evaluate(t);
    }

    abstract Polynomial computeSegment(int var1);
}

