/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.curves.ClonePoint;
import com.lightcrafts.ui.region.curves.InnerShape;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;

abstract class AbstractCurve
implements Curve {
    GeneralPath shape;
    LinkedList segments;
    LinkedList points = new LinkedList();
    private static final float NominalRadius = 2.0f;
    private float radius;
    private Stroke regularStroke;
    private Stroke backgroundStroke;
    private Stroke highlightStroke;
    private Stroke mouseHitStroke;
    private static final Color ForegroundColor = Color.black;
    private static final Color InnerShapeColor = Color.gray;
    private static final Color BackgroundColor = Color.white;
    private static final Color InteriorColor = new Color(255, 255, 255, 64);
    private static final float MinimumInnerSize = 4.0f;
    private boolean showInnerShape;
    private Shape innerShape;
    private float width;
    private ClonePoint clonePt;
    private int highlightPoint;
    private int highlightSegment;
    private boolean highlightSegments;
    private boolean highlightGlobal;
    private boolean highlightInterior;
    private Color oldColor;
    private Stroke oldStroke;
    private static final String PointTag = "Point";
    private static final String WidthTag = "Width";
    private static final String CloneTag = "Clone";

    public AbstractCurve() {
        this.segments = new LinkedList();
        this.updateStrokes(2.0f);
        this.resetHighlights();
    }

    @Override
    public boolean allowsAddRemovePoints() {
        return true;
    }

    @Override
    public int addPoint(Point2D p) {
        this.points.add(p);
        this.updateShapes();
        return this.points.size() - 1;
    }

    @Override
    public void insertPoint(int n, Point2D p) {
        this.points.add(n, p);
        this.updateShapes();
    }

    @Override
    public void removePoint(int n) {
        this.points.remove(n);
        this.updateShapes();
    }

    @Override
    public void movePoint(int n, Point2D p) {
        this.points.set(n, p);
        this.updateShapes();
    }

    @Override
    public void translate(double dx, double dy) {
        for (Point2D p : this.points) {
            double x = p.getX() + dx;
            double y = p.getY() + dy;
            p.setLocation(x, y);
        }
        if (this.clonePt != null) {
            this.clonePt.translate(dx, dy);
        }
        this.updateShapes();
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean isValidShape() {
        return this.shape != null && this.points.size() >= 3;
    }

    @Override
    public Rectangle2D getPaintBounds() {
        Rectangle2D bounds = null;
        if (this.shape != null) {
            bounds = this.shape.getBounds();
            for (Point2D p : this.points) {
                Rectangle2D r = this.getPointBounds(p);
                bounds.add(r);
            }
            if (this.clonePt != null) {
                bounds.add(this.clonePt.getPaintBounds());
            }
        } else if (this.points.size() == 1) {
            bounds = this.getPointBounds((Point2D)this.points.get(0));
            if (this.clonePt != null) {
                bounds.add(this.clonePt.getPaintBounds());
            }
        } else if (this.clonePt != null) {
            bounds = this.clonePt.getPaintBounds();
        }
        return bounds;
    }

    @Override
    public boolean isOnCurve(Point2D p) {
        Shape thickShape;
        if (this.shape != null && (thickShape = this.mouseHitStroke.createStrokedShape(this.shape)).contains(p)) {
            return true;
        }
        return this.getPointAt(p) >= 0;
    }

    @Override
    public int getSegmentAt(Point2D p) {
        int n = 0;
        for (Shape thinSegment : this.segments) {
            Shape thickSegment = this.mouseHitStroke.createStrokedShape(thinSegment);
            if (thickSegment.contains(p)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getPointAt(Point2D p) {
        for (int n = 0; n < this.points.size(); ++n) {
            Point2D q = (Point2D)this.points.get(n);
            if (!(p.distance(q) < (double)(4.0f * this.radius))) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void setShowInnerShape(boolean show) {
        if (this.showInnerShape != show) {
            this.showInnerShape = show;
            if (this.showInnerShape) {
                this.updateInnerShape();
            } else {
                this.innerShape = null;
            }
        }
    }

    @Override
    public boolean getShowInnerShape() {
        return this.showInnerShape;
    }

    @Override
    public boolean isInnerShape(Point2D p) {
        if (this.showInnerShape) {
            Shape thickInnerShape = this.mouseHitStroke.createStrokedShape(this.innerShape);
            return thickInnerShape.contains(p);
        }
        return false;
    }

    @Override
    public void setInnerShape(Point2D p) {
        this.width = p != null ? InnerShape.getWidth(this.shape, p) : InnerShape.getDefaultWidth(this.shape, this.width);
        if (this.showInnerShape) {
            this.updateInnerShape();
        }
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(float width) {
        this.width = width;
        if (this.showInnerShape) {
            this.updateInnerShape();
        }
    }

    private void updateInnerShape() {
        if (this.isValidShape()) {
            Rectangle2D bounds;
            double size;
            float w = this.width;
            do {
                float f = w;
                w = f - 1.0f;
                this.innerShape = InnerShape.getInnerShape(this.shape, f);
            } while ((size = Math.min((bounds = this.innerShape.getBounds2D()).getWidth(), bounds.getHeight())) < 4.0 && w >= 1.0f);
        } else {
            this.innerShape = null;
        }
    }

    @Override
    public void setClonePoint(Point2D p) {
        if (this.clonePt == null) {
            this.clonePt = new ClonePoint(p);
        }
        this.clonePt.setPoint(p);
    }

    @Override
    public Point2D getClonePoint() {
        return this.clonePt != null ? this.clonePt.getPoint() : null;
    }

    @Override
    public boolean isClonePoint(Point2D p) {
        return this.clonePt != null ? this.clonePt.isAt(p) : false;
    }

    @Override
    public void resetHighlights() {
        this.highlightPoint = -1;
        this.highlightSegment = -1;
        this.highlightSegments = false;
        this.highlightGlobal = false;
    }

    @Override
    public void highlightPoint(int index) {
        this.resetHighlights();
        this.highlightPoint = index;
    }

    @Override
    public void highlightSegment(int index) {
        this.resetHighlights();
        this.highlightSegment = index;
    }

    @Override
    public void highlightAllSegments() {
        this.resetHighlights();
        this.highlightSegments = true;
    }

    @Override
    public void highlightAll() {
        this.resetHighlights();
        this.highlightGlobal = true;
    }

    @Override
    public void highlightInterior(boolean on) {
        this.highlightInterior = on;
    }

    @Override
    public void paint(Graphics2D g, boolean showClonePoint) {
        Point2D p;
        this.saveGraphics(g);
        AffineTransform xform = g.getTransform();
        float scale = (float)Math.sqrt(Math.abs(xform.getDeterminant()));
        float r = 2.0f / scale;
        if (r != this.radius) {
            this.updateStrokes(r);
        }
        Rectangle clip = g.getClipBounds();
        if (this.shape != null) {
            Rectangle2D bounds = this.getPaintBounds();
            if (bounds.intersects(clip)) {
                if (this.highlightGlobal || this.highlightSegments) {
                    this.drawHighlight(g, this.shape);
                } else {
                    this.drawRegular(g, this.shape);
                }
                if (this.highlightGlobal) {
                    for (Point2D p2 : this.points) {
                        this.drawPointRegular(g, p2);
                    }
                    if (this.innerShape != null) {
                        this.drawInner(g, this.innerShape);
                    }
                }
            }
        } else if (this.points.size() == 1) {
            p = (Point2D)this.points.iterator().next();
            this.drawPointRegular(g, p);
        }
        if (this.highlightPoint >= 0) {
            g.setStroke(this.highlightStroke);
            p = (Point2D)this.points.get(this.highlightPoint);
            this.drawPointHighlight(g, p);
        }
        if (this.highlightSegment >= 0) {
            Shape segment = (Shape)this.segments.get(this.highlightSegment);
            this.drawHighlight(g, segment);
        }
        if (this.highlightInterior) {
            g.setColor(InteriorColor);
            g.fill(this.shape);
        }
        if (showClonePoint) {
            this.clonePt.paint(g);
        }
        this.restoreGraphics(g);
    }

    @Override
    public boolean matches(Curve c) {
        if (!c.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractCurve curve = (AbstractCurve)c;
        LinkedList p = curve.points;
        if (this.points.size() != p.size()) {
            return false;
        }
        Iterator i = this.points.iterator();
        Iterator j = p.iterator();
        while (i.hasNext()) {
            if (i.next().equals(j.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        AbstractCurve clone = null;
        try {
            clone = (AbstractCurve)super.clone();
            if (this.clonePt != null) {
                clone.clonePt = (ClonePoint)this.clonePt.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Broken Curve.clone(): " + e.getMessage());
        }
        clone.segments = new LinkedList();
        for (Shape segment : this.segments) {
            if (segment instanceof Line2D) {
                segment = (Line2D)((Line2D)segment).clone();
            } else if (segment instanceof QuadCurve2D) {
                segment = (QuadCurve2D)((QuadCurve2D)segment).clone();
            } else if (segment instanceof CubicCurve2D) {
                segment = (CubicCurve2D)((CubicCurve2D)segment).clone();
            } else {
                System.err.println("Curve.clone(): non-Cloneable segment");
            }
            clone.segments.add(segment);
        }
        clone.points = new LinkedList();
        for (Point2D p : this.points) {
            p = (Point2D)p.clone();
            clone.points.add(p);
        }
        clone.updateShapes();
        return clone;
    }

    private void updateStrokes(float r) {
        this.radius = r;
        this.regularStroke = new BasicStroke(this.radius * 0.6f);
        this.backgroundStroke = new BasicStroke(this.radius);
        this.highlightStroke = new BasicStroke(this.radius * 0.6f, 1, 1, this.radius * 2.0f, new float[]{this.radius, this.radius}, 0.0f);
        this.mouseHitStroke = new BasicStroke(4.0f * this.radius);
    }

    private void drawHighlight(Graphics2D g, Shape shape) {
        this.setGraphicsBackground(g);
        g.draw(shape);
        this.setGraphicsHighlight(g);
        g.draw(shape);
    }

    private void drawRegular(Graphics2D g, Shape shape) {
        this.setGraphicsBackground(g);
        g.draw(shape);
        this.setGraphicsRegular(g);
        g.draw(shape);
    }

    private void drawInner(Graphics2D g, Shape shape) {
        this.setGraphicsBackground(g);
        g.draw(shape);
        this.setGraphicsInner(g);
        g.draw(shape);
    }

    private void setGraphicsBackground(Graphics2D g) {
        g.setColor(BackgroundColor);
        g.setStroke(this.backgroundStroke);
    }

    private void setGraphicsRegular(Graphics2D g) {
        g.setColor(ForegroundColor);
        g.setStroke(this.regularStroke);
    }

    private void setGraphicsInner(Graphics2D g) {
        g.setColor(InnerShapeColor);
        g.setStroke(this.regularStroke);
    }

    private void setGraphicsHighlight(Graphics2D g) {
        g.setColor(ForegroundColor);
        g.setStroke(this.highlightStroke);
    }

    private void drawPointRegular(Graphics2D g, Point2D p) {
        this.setGraphicsBackground(g);
        this.fillPoint(g, p);
        this.setGraphicsRegular(g);
        this.drawPoint(g, p);
    }

    private void drawPointHighlight(Graphics2D g, Point2D p) {
        this.setGraphicsBackground(g);
        this.fillPoint(g, p);
        this.setGraphicsHighlight(g);
        this.drawPoint(g, p);
    }

    private void drawPoint(Graphics2D g, Point2D p) {
        Shape shape = this.getPointShape(p);
        g.draw(shape);
    }

    private void fillPoint(Graphics2D g, Point2D p) {
        Shape shape = this.getPointShape(p);
        g.fill(shape);
    }

    private Shape getPointShape(Point2D p) {
        return new Arc2D.Double(p.getX() - (double)(2.0f * this.radius), p.getY() - (double)(2.0f * this.radius), 4.0f * this.radius, 4.0f * this.radius, 0.0, 360.0, 1);
    }

    private Rectangle2D getPointBounds(Point2D p) {
        Shape pointShape = this.getPointShape(p);
        Shape thickShape = this.backgroundStroke.createStrokedShape(pointShape);
        return thickShape.getBounds();
    }

    private void updateShapes() {
        this.updateShape();
        if (this.showInnerShape) {
            this.updateInnerShape();
        }
    }

    private void saveGraphics(Graphics2D g) {
        this.oldColor = g.getColor();
        this.oldStroke = g.getStroke();
    }

    private void restoreGraphics(Graphics2D g) {
        g.setColor(this.oldColor);
        g.setStroke(this.oldStroke);
    }

    @Override
    public void save(XmlNode node) {
        node.setAttribute(WidthTag, Float.toString(this.width));
        for (Point2D p : this.points) {
            XmlNode pointNode = node.addChild(PointTag);
            pointNode.setAttribute("x", Double.toString(p.getX()));
            pointNode.setAttribute("y", Double.toString(p.getY()));
        }
        if (this.clonePt != null) {
            node = node.addChild(CloneTag);
            this.clonePt.save(node);
        }
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        try {
            this.width = Float.parseFloat(node.getAttribute(WidthTag));
        }
        catch (NumberFormatException e) {
            throw new XMLException("Invalid curve width", e);
        }
        this.points.clear();
        XmlNode[] children = node.getChildren();
        for (int n = 0; n < children.length; ++n) {
            XmlNode child = children[n];
            if (!child.getName().equals(PointTag)) continue;
            try {
                double x = Double.parseDouble(child.getAttribute("x"));
                double y = Double.parseDouble(child.getAttribute("y"));
                Point2D.Double p = new Point2D.Double(x, y);
                this.points.add(p);
                continue;
            }
            catch (NumberFormatException e) {
                throw new XMLException("Invalid curve coordinates", e);
            }
        }
        this.updateShapes();
        if (node.hasChild(CloneTag)) {
            this.clonePt = new ClonePoint();
            node = node.getChild(CloneTag);
            this.clonePt.restore(node);
        }
    }

    abstract void updateShape();

    @Override
    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.shape.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.shape.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.shape.contains(p);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.shape.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.shape.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.shape.contains(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.shape.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.shape.getPathIterator(at, flatness);
    }
}

