/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.model.Contour;
import com.lightcrafts.model.Region;
import com.lightcrafts.ui.action.ToggleAction;
import com.lightcrafts.ui.mode.Mode;
import com.lightcrafts.ui.region.ContourRegion;
import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveComponent;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.NewCurveMode;
import com.lightcrafts.ui.region.RegionChangeMulticaster;
import com.lightcrafts.ui.region.RegionListener;
import com.lightcrafts.ui.region.RegionModel;
import com.lightcrafts.ui.region.SharedShape;
import com.lightcrafts.ui.region.ShowHideRegionsAction;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditListener;

public class RegionOverlay
extends JPanel
implements Mode {
    private CurveComponent overlay;
    private Map overlays;
    private Rectangle underlayBounds;
    private RegionModel model;
    private RegionChangeMulticaster multicaster;
    private AffineTransform xform;
    private boolean m_entered;
    private Collection mouseListeners;
    private ShowHideRegionsAction showHideToggle;

    public RegionOverlay() {
        this.setLayout(null);
        this.overlays = new HashMap();
        this.model = new RegionModel(this);
        this.showHideToggle = new ShowHideRegionsAction(this);
        this.multicaster = new RegionChangeMulticaster();
        this.mouseListeners = new LinkedList();
        this.addPopupListener();
    }

    @Override
    public void enter() {
        this.m_entered = true;
    }

    @Override
    public void exit() {
        this.m_entered = false;
    }

    @Override
    public boolean isIn() {
        return this.m_entered;
    }

    public ToggleAction getShowHideAction() {
        return this.showHideToggle;
    }

    public void finishEditingCurve() {
        if (this.overlay != null) {
            this.overlay.finishEditingCurve();
        }
    }

    void setRegionsVisible(boolean visible) {
        if (visible) {
            this.addOverlay();
        } else {
            this.removeOverlay();
        }
    }

    public void setCurveType(int type) {
        this.model.setNewCurveType(type);
    }

    public int getCurveType() {
        return this.model.getNewCurveType();
    }

    public void setCookie(Object cookie) {
        this.setCookie(cookie, false, false);
    }

    public void setCookie(Object cookie, boolean clonePts, boolean spotCurves) {
        if (this.overlay != null && this.showHideToggle.isRegionsVisible()) {
            this.model.setMajorMode(new NewCurveMode(this.model, this.overlay));
            this.removeOverlay();
        }
        CurveSelection selection = this.model.getSelection();
        selection.setCookie(cookie);
        if (cookie == null) {
            this.overlay = null;
            return;
        }
        if (this.overlays.containsKey(cookie)) {
            this.overlay = (CurveComponent)this.overlays.get(cookie);
        } else {
            this.overlay = new CurveComponent(this.model, clonePts, spotCurves);
            this.overlay.setOpaque(false);
            this.overlays.put(cookie, this.overlay);
            this.overlay.setCookie(cookie);
            this.model.addComponent(this.overlay);
        }
        this.model.setMajorMode(new NewCurveMode(this.model, this.overlay));
        if (this.xform != null) {
            this.overlay.setTransform(this.xform);
        }
        if (this.showHideToggle.isRegionsVisible()) {
            this.addOverlay();
        }
    }

    public boolean hasCookie(Object cookie) {
        return this.overlays.containsKey(cookie);
    }

    public boolean isCookie(Object cookie) {
        return cookie.equals(this.overlay.getCookie());
    }

    public Region getRegion(Object cookie) {
        CurveComponent comp;
        Set curves;
        if (cookie != null && !(curves = this.model.getCurves(comp = (CurveComponent)this.overlays.get(cookie))).isEmpty()) {
            ArrayList<Contour> contours = new ArrayList<Contour>();
            for (Curve curve : curves) {
                Contour contour = this.model.getContour(curve);
                contours.add(contour);
            }
            ContourRegion region = new ContourRegion(contours);
            return region;
        }
        return null;
    }

    public Collection getShapes(Object cookie) {
        if (cookie == null) {
            return null;
        }
        CurveComponent comp = (CurveComponent)this.overlays.get(cookie);
        Set curves = this.model.getCurves(comp);
        HashSet<Curve> shapes = new HashSet<Curve>();
        for (Curve curve : curves) {
            if (!curve.isValidShape()) continue;
            shapes.add(curve);
        }
        return shapes;
    }

    public Collection getAllShapes() {
        Set curves = this.model.getAllCurves();
        HashSet<Curve> shapes = new HashSet<Curve>();
        for (Curve curve : curves) {
            if (!curve.isValidShape()) continue;
            shapes.add(curve);
        }
        return shapes;
    }

    public void shareShape(Object cookie, SharedShape shape, boolean clone) {
        Curve curve = (Curve)shape;
        if (clone) {
            curve = (Curve)curve.clone();
        }
        CurveComponent comp = (CurveComponent)this.overlays.get(cookie);
        this.model.addCurve(comp, curve);
    }

    public void unShareShape(Object cookie, SharedShape shape) {
        Curve curve = (Curve)shape;
        CurveComponent comp = (CurveComponent)this.overlays.get(cookie);
        this.model.removeCurve(comp, curve);
    }

    public void removeShape(SharedShape shape) {
        this.model.removeCurve((Curve)shape);
    }

    public void save(List cookies, XmlNode node) {
        LinkedList<CurveComponent> comps = new LinkedList<CurveComponent>();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            CurveComponent comp = (CurveComponent)this.overlays.get(i.next());
            comps.add(comp);
        }
        this.model.save(comps, node);
    }

    public void restore(List cookies, XmlNode node) throws XMLException {
        LinkedList<CurveComponent> comps = new LinkedList<CurveComponent>();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            CurveComponent comp = (CurveComponent)this.overlays.get(i.next());
            comps.add(comp);
        }
        this.model.restore(comps, node);
    }

    public void addSaved(List cookies, XmlNode node) throws XMLException {
        LinkedList<CurveComponent> comps = new LinkedList<CurveComponent>();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            CurveComponent comp = (CurveComponent)this.overlays.get(i.next());
            comps.add(comp);
        }
        this.model.addSaved(comps, node);
    }

    @Override
    public void setTransform(AffineTransform xform) {
        this.xform = xform;
        if (this.overlay != null) {
            this.overlay.setTransform(xform);
        }
    }

    @Override
    public void setUnderlayBounds(Rectangle bounds) {
        this.underlayBounds = bounds;
    }

    public Rectangle getUnderlayBounds() {
        return this.underlayBounds;
    }

    @Override
    public void doLayout() {
        if (this.overlay != null) {
            Dimension size = this.getSize();
            this.overlay.setLocation(0, 0);
            this.overlay.setSize(size);
        }
    }

    void regionBatchStart(Collection comps) {
        Collection cookies = this.getCookies(comps);
        this.multicaster.regionBatchStart(cookies);
    }

    void regionChanged(Collection comps, Curve curve) {
        if (curve.isValidShape()) {
            Collection cookies = this.getCookies(comps);
            this.multicaster.regionChanged(cookies, curve);
        }
    }

    void regionsBatchEnd(Collection comps) {
        Collection cookies = this.getCookies(comps);
        this.multicaster.regionBatchEnd(cookies);
    }

    private Collection getCookies(Collection comps) {
        HashSet<Object> cookies = new HashSet<Object>();
        for (CurveComponent comp : comps) {
            Object cookie = comp.getCookie();
            cookies.add(cookie);
        }
        return cookies;
    }

    public void addRegionListener(RegionListener listener) {
        this.multicaster.add(listener);
    }

    public void removeRegionListener(RegionListener listener) {
        this.multicaster.remove(listener);
    }

    public void addSelectionListener(CurveSelection.Listener listener) {
        CurveSelection selection = this.model.getSelection();
        selection.addSelectionListener(listener);
    }

    public void removeSelectionListener(CurveSelection.Listener listener) {
        CurveSelection selection = this.model.getSelection();
        selection.removeSelectionListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.model.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.model.removeUndoableEditListener(listener);
    }

    private void addOverlay() {
        if (this.overlay != null) {
            this.add(this.overlay);
            for (MouseInputListener listener : this.mouseListeners) {
                this.overlay.addMouseListener(listener);
                this.overlay.addMouseMotionListener(listener);
            }
            this.validate();
            this.repaint();
        }
    }

    private void removeOverlay() {
        if (this.overlay != null) {
            this.remove(this.overlay);
            for (MouseInputListener listener : this.mouseListeners) {
                this.overlay.removeMouseListener(listener);
                this.overlay.removeMouseMotionListener(listener);
            }
            Rectangle bounds = this.overlay.getBounds();
            this.repaint(bounds);
        }
    }

    private void addPopupListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    RegionOverlay.this.showPopup(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    RegionOverlay.this.showPopup(event);
                }
            }
        });
    }

    private void showPopup(MouseEvent event) {
        if (event.isPopupTrigger() && !this.showHideToggle.getState()) {
            JMenuItem item = new JMenuItem("Show Regions");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    RegionOverlay.this.showHideToggle.setState(true);
                }
            });
            JPopupMenu popup = new JPopupMenu();
            popup.add(item);
            popup.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    @Override
    public JComponent getOverlay() {
        return this;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.mouseListeners.add(listener);
        if (this.overlay != null) {
            this.overlay.addMouseListener(listener);
            this.overlay.addMouseMotionListener(listener);
        }
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.mouseListeners.remove(listener);
        if (this.overlay != null) {
            this.overlay.removeMouseListener(listener);
            this.overlay.removeMouseMotionListener(listener);
        }
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
    }

    @Override
    public boolean wantsAutocroll() {
        return true;
    }

    @Override
    public void dispose() {
    }
}

