/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.CurveComponent;
import com.lightcrafts.ui.region.RegionModel;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.event.MouseInputAdapter;

abstract class RegionMode
extends MouseInputAdapter {
    private static final ResourceBundle HotPointResources = ResourceBundle.getBundle("com/lightcrafts/ui/region/resources/HotPoints");
    static Cursor NewCurveCursor = RegionMode.createCursor("new_region");
    static Cursor MoveCurveCursor = RegionMode.createCursor("move_curve");
    static Cursor MovingCurveCursor = RegionMode.createCursor("moving_curve");
    static Cursor MovePointCursor = RegionMode.createCursor("move_point");
    static Cursor MovingPointCursor = RegionMode.createCursor("moving_curve");
    static Cursor NewPointCursor = RegionMode.createCursor("new_point");
    static Cursor DefaultCursor = new Cursor(0);
    RegionModel model;
    CurveComponent comp;
    Cursor cursor;

    RegionMode(RegionMode oldMode) {
        this.model = oldMode.model;
        this.comp = oldMode.comp;
    }

    RegionMode(RegionModel model, CurveComponent comp) {
        this.model = model;
        this.comp = comp;
    }

    void autoscroll(MouseEvent event) {
        Rectangle r = new Rectangle(event.getX(), event.getY(), 1, 1);
        this.comp.scrollRectToVisible(r);
    }

    static boolean isModified(MouseEvent event) {
        return event.isShiftDown() || event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown();
    }

    private static Cursor createCursor(String name) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String path = "resources/" + name + ".png";
        URL url = RegionMode.class.getResource(path);
        Image image = toolkit.createImage(url);
        int x = Integer.parseInt(HotPointResources.getString(name + "X"));
        int y = Integer.parseInt(HotPointResources.getString(name + "Y"));
        Point hot = new Point(x, y);
        Cursor cursor = toolkit.createCustomCursor(image, hot, name);
        return cursor;
    }
}

