/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.MinorRegionMode;
import com.lightcrafts.ui.region.NewCurveMode;
import com.lightcrafts.ui.region.RegionMode;
import java.awt.Point;
import java.awt.event.MouseEvent;

class MoveCurveMode
extends MinorRegionMode {
    private Point startPoint;
    private Point currentPoint;
    private CurveIterator curves;

    MoveCurveMode(RegionMode oldMode, Point initPoint) {
        super(oldMode);
        this.currentPoint = this.startPoint = initPoint;
        CurveSelection selection = this.model.getSelection();
        this.curves = selection.iterator();
        this.comp.setCursor(MovingCurveCursor);
        while (this.curves.hasNext()) {
            this.model.notifyChangeStart(this.curves.nextCurve());
        }
        this.model.editStart();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.currentPoint.equals(this.startPoint)) {
            this.model.editEnd();
        } else {
            this.model.editCancel();
        }
        Point p = event.getPoint();
        this.update(p, false);
        this.curves.reset();
        while (this.curves.hasNext()) {
            this.model.notifyChangeEnd(this.curves.nextCurve());
        }
        this.model.setMajorMode(new NewCurveMode(this));
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    private void update(Point p, boolean isUpdating) {
        this.curves.reset();
        while (this.curves.hasNext()) {
            this.comp.moveCurve(this.curves.nextCurve(), this.currentPoint, p, isUpdating);
        }
        this.currentPoint = p;
    }
}

