/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.action.ToggleAction;
import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveNudger;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.Locale;
import com.lightcrafts.ui.region.NewCurveMode;
import com.lightcrafts.ui.region.RegionMode;
import com.lightcrafts.ui.region.RegionModel;
import com.lightcrafts.ui.region.RegionOverlay;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

class CurveComponent
extends JComponent
implements CurveSelection.Listener,
RegionModel.Listener {
    private RegionModel model;
    private CurveSelection selection;
    private AffineTransform xform;
    private Curve updatingCurve;
    private boolean showClonePts;
    private boolean makeSpotCurves;
    private Object cookie;

    CurveComponent(RegionModel model, boolean clonePts, boolean spotCurves) {
        this.model = model;
        this.showClonePts = clonePts;
        this.makeSpotCurves = spotCurves;
        model.addListener(this);
        this.selection = model.getSelection();
        this.selection.addSelectionListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                CurveComponent.this.requestFocusInWindow();
                if (event.isPopupTrigger()) {
                    CurveComponent.this.handlePopup(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    CurveComponent.this.handlePopup(event);
                }
            }
        });
        final CurveNudger nudger = new CurveNudger(model, this);
        this.selection.addSelectionListener(new CurveSelection.Listener(){

            @Override
            public void selectionChanged(CurveIterator oldSelection, CurveIterator newSelection) {
                if (newSelection.hasNext()) {
                    nudger.registerKeys();
                } else {
                    nudger.unregisterKeys();
                }
            }
        });
    }

    void finishEditingCurve() {
        this.model.setEditingCurve(null);
    }

    Curve addCurve() {
        Curve curve = this.model.createCurve(this);
        return curve;
    }

    Curve addCloneCurve(Point2D p) {
        p = this.invertPoint(p);
        Curve curve = this.model.createCurve(this, p);
        Rectangle2D bounds = this.getPaintBounds(curve);
        this.repaint(bounds);
        return curve;
    }

    Curve addSpotCurve(Point2D p) {
        p = this.invertPoint(p);
        Curve curve = this.model.createSpotCurve(this, p);
        Rectangle2D bounds = this.getPaintBounds(curve);
        this.repaint(bounds);
        return curve;
    }

    void removeCurve(Curve curve) {
        Rectangle2D bounds = this.getPaintBounds(curve);
        if (this.model.isEditingCurve(curve)) {
            this.model.editStart();
            this.model.removeCurve(this, curve);
            this.model.setMajorMode(new NewCurveMode(this.model, this));
            this.model.editEnd();
        } else {
            this.model.removeCurve(this, curve);
        }
        this.repaint(bounds);
    }

    void removeCurveWithoutModeChange(Curve curve) {
        Rectangle2D bounds = this.getPaintBounds(curve);
        this.model.removeCurve(this, curve);
        this.repaint(bounds);
    }

    void removeAllCurves() {
        Rectangle2D bounds = null;
        Set curves = this.model.getCurves(this);
        for (Curve curve : curves) {
            if (bounds == null) {
                bounds = this.getPaintBounds(curve);
            } else {
                bounds.add(this.getPaintBounds(curve));
            }
            this.model.removeCurve(this, curve);
        }
        if (bounds != null) {
            this.repaint(bounds);
        }
    }

    int addPoint(Curve curve, Point2D p) {
        p = this.invertPoint(p);
        Rectangle2D oldBounds = curve.getPaintBounds();
        int index = curve.addPoint(p);
        Rectangle2D newBounds = curve.getPaintBounds();
        this.model.notifyChanged(curve);
        this.repaint(oldBounds, newBounds);
        return index;
    }

    void insertPoint(Curve curve, int index, Point2D p) {
        p = this.invertPoint(p);
        Rectangle2D oldBounds = curve.getPaintBounds();
        curve.insertPoint(index, p);
        Rectangle2D newBounds = curve.getPaintBounds();
        this.model.notifyChanged(curve);
        this.repaint(oldBounds, newBounds);
    }

    void removePoint(Curve curve, int index) {
        Rectangle2D oldBounds = curve.getPaintBounds();
        this.model.editStart();
        curve.removePoint(index);
        if (curve.isValidShape()) {
            this.model.notifyChanged(curve);
        } else {
            oldBounds = this.getPaintBounds(curve);
            this.removeCurve(curve);
        }
        this.model.editEnd();
        Rectangle2D newBounds = curve.getPaintBounds();
        this.repaint(oldBounds, newBounds);
    }

    void movePoint(Curve curve, int index, Point2D p, boolean isMoving) {
        this.updatingCurve = isMoving ? curve : null;
        this.movePoint(curve, index, p);
    }

    void movePoint(Curve curve, int index, Point2D p) {
        p = this.invertPoint(p);
        Rectangle2D oldBounds = curve.getPaintBounds();
        curve.movePoint(index, p);
        Rectangle2D newBounds = curve.getPaintBounds();
        this.model.notifyChanged(curve);
        this.repaint(oldBounds, newBounds);
    }

    void moveCurve(Curve curve, Point2D p1, Point2D p2, boolean isMoving) {
        this.updatingCurve = isMoving ? curve : null;
        this.moveCurve(curve, p1, p2);
    }

    void moveCurve(Curve curve, Point2D p1, Point2D p2) {
        Rectangle2D oldBounds = curve.getPaintBounds();
        p1 = this.invertPoint(p1);
        p2 = this.invertPoint(p2);
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        curve.translate(dx, dy);
        Rectangle2D newBounds = curve.getPaintBounds();
        this.model.notifyTranslated(curve, dx, dy);
        this.repaint(oldBounds, newBounds);
    }

    Curve getCurveAt(Point2D p) {
        p = this.invertPoint(p);
        Set curves = this.model.getCurves(this);
        for (Curve curve : curves) {
            if (!curve.isOnCurve(p)) continue;
            return curve;
        }
        return null;
    }

    Curve getCurveAround(Point2D p) {
        p = this.invertPoint(p);
        Set curves = this.model.getCurves(this);
        for (Curve curve : curves) {
            if (!curve.isValidShape() || !curve.contains(p)) continue;
            return curve;
        }
        return null;
    }

    Set getCurves() {
        return this.model.getCurves(this);
    }

    int getPointAt(Curve curve, Point2D p) {
        p = this.invertPoint(p);
        return curve.getPointAt(p);
    }

    int getSegmentAt(Curve curve, Point2D p) {
        p = this.invertPoint(p);
        return curve.getSegmentAt(p);
    }

    boolean isInnerShapeAt(Curve curve, Point2D p) {
        p = this.invertPoint(p);
        return curve.isInnerShape(p);
    }

    void setInnerShapeAt(Curve curve, Point2D p, boolean isChanging) {
        this.updatingCurve = isChanging ? curve : null;
        this.setInnerShapeAt(curve, p);
    }

    void setInnerShapeAt(Curve curve, Point2D p) {
        if (p != null) {
            p = this.invertPoint(p);
        }
        curve.setInnerShape(p);
        this.model.notifyChanged(curve);
        Rectangle2D bounds = curve.getPaintBounds();
        this.repaint(bounds);
    }

    boolean isClonePointAt(Curve curve, Point2D p) {
        p = this.invertPoint(p);
        return curve.isClonePoint(p);
    }

    boolean showsClonePoints() {
        return this.showClonePts;
    }

    boolean makesSpotCurves() {
        return this.makeSpotCurves;
    }

    void setClonePoint(Curve curve, Point2D p1, Point2D p2, boolean isMoving) {
        this.updatingCurve = isMoving ? curve : null;
        this.setClonePoint(curve, p1, p2);
    }

    void setClonePoint(Curve curve, Point2D p1, Point2D p2) {
        Point2D clonePt = this.model.getClonePoint(curve);
        Rectangle2D oldBounds = curve.getPaintBounds();
        p1 = this.invertPoint(p1);
        p2 = this.invertPoint(p2);
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        clonePt.setLocation(clonePt.getX() + dx, clonePt.getY() + dy);
        curve.setClonePoint(clonePt);
        Rectangle2D newBounds = curve.getPaintBounds();
        this.repaint(oldBounds, newBounds);
        this.model.notifyChanged(curve);
    }

    Shape getShape() {
        Set curves = this.model.getCurves(this);
        if (curves.isEmpty()) {
            return null;
        }
        Area area = new Area();
        boolean isValid = false;
        for (Curve curve : curves) {
            if (!curve.isValidShape()) continue;
            Area a = new Area(curve);
            area.add(a);
            isValid = true;
        }
        if (!isValid) {
            return null;
        }
        return area;
    }

    void setTransform(AffineTransform xform) {
        this.xform = xform;
        this.repaint();
    }

    @Override
    public void selectionChanged(CurveIterator oldSelection, CurveIterator newSelection) {
        Rectangle2D oldBounds = null;
        Rectangle2D newBounds = null;
        if (oldSelection.hasNext()) {
            Curve oldCurve = oldSelection.nextCurve();
            oldBounds = oldCurve.getPaintBounds();
            while (oldSelection.hasNext()) {
                oldCurve = oldSelection.nextCurve();
                oldBounds.add(oldCurve.getPaintBounds());
            }
        }
        Set curves = this.model.getCurves(this);
        for (Curve c : curves) {
            c.resetHighlights();
        }
        if (newSelection.hasNext()) {
            Curve newCurve = newSelection.nextCurve();
            newCurve.highlightAllSegments();
            newBounds = newCurve.getPaintBounds();
            while (newSelection.hasNext()) {
                newCurve = newSelection.nextCurve();
                newCurve.highlightAllSegments();
                newBounds.add(newCurve.getPaintBounds());
            }
        }
        if (oldBounds != null || newBounds != null) {
            this.repaint(oldBounds, newBounds);
        }
    }

    void setCookie(Object cookie) {
        this.cookie = cookie;
    }

    Object getCookie() {
        return this.cookie;
    }

    private void repaint(Rectangle2D oldBounds, Rectangle2D newBounds) {
        if (oldBounds == null) {
            this.repaint(newBounds);
        } else if (newBounds == null) {
            this.repaint(oldBounds);
        } else {
            Rectangle2D union = oldBounds.createUnion(newBounds);
            this.repaint(union);
        }
    }

    private void repaint(Shape shape) {
        if (this.xform != null) {
            shape = this.xform.createTransformedShape(shape);
        }
        Rectangle bounds = shape.getBounds();
        this.repaint(0L, bounds.x, bounds.y, bounds.width + 1, bounds.height + 1);
    }

    void repaint(Curve curve) {
        Rectangle2D bounds = curve.getPaintBounds();
        this.repaint(bounds);
    }

    private Rectangle2D getPaintBounds(Curve curve) {
        return curve.getPaintBounds();
    }

    private Point2D invertPoint(Point2D p) {
        if (this.xform == null) {
            return (Point2D)p.clone();
        }
        try {
            return this.xform.inverseTransform(p, null);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException("Scaling failed", e);
        }
    }

    private void handlePopup(MouseEvent event) {
        Point p = event.getPoint();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = null;
        Curve curveAt = this.getCurveAt(p);
        Curve curveAround = this.getCurveAround(p);
        final Curve curve = curveAt != null ? curveAt : curveAround;
        item = new JMenuItem(Locale.LOCALE.get("HideRegionsMenuItem"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RegionOverlay overlay = (RegionOverlay)CurveComponent.this.getParent();
                ToggleAction showHideAction = overlay.getShowHideAction();
                showHideAction.actionPerformed(event);
            }
        });
        menu.add(item);
        if (curve != null) {
            if (this.model.isEditingCurve(curve)) {
                item = curve.getShowInnerShape() ? new JMenuItem(Locale.LOCALE.get("HideInnerRegionMenuItem")) : new JMenuItem(Locale.LOCALE.get("ShowInnerRegionMenuItem"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        boolean showHide = curve.getShowInnerShape();
                        curve.setShowInnerShape(!showHide);
                        CurveComponent.this.repaint(curve);
                    }
                });
                menu.add(item);
            }
            menu.add(new JSeparator());
            final int index = this.getPointAt(curve, p);
            if (index >= 0 && curve.allowsAddRemovePoints()) {
                item = new JMenuItem(Locale.LOCALE.get("DeletePointMenuItem"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        CurveComponent.this.removePoint(curve, index);
                    }
                });
                menu.add(item);
            }
            if (curve != null) {
                item = new JMenuItem(Locale.LOCALE.get("DeleteRegionMenuItem"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        CurveComponent.this.removeCurve(curve);
                    }
                });
                menu.add(item);
            }
        }
        menu.show(this, p.x, p.y);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        RenderingHints oldHints = g.getRenderingHints();
        Composite oldComposite = g.getComposite();
        AffineTransform oldTransform = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.xform != null) {
            AffineTransform newTransform = (AffineTransform)oldTransform.clone();
            newTransform.concatenate(this.xform);
            g.setTransform(newTransform);
        }
        AlphaComposite updatingBlend = AlphaComposite.getInstance(3, 0.25f);
        AlphaComposite normalBlend = AlphaComposite.getInstance(3, 0.75f);
        Set curves = this.model.getCurves(this);
        for (Curve curve : curves) {
            if (curve == this.updatingCurve) {
                g.setComposite(updatingBlend);
            } else {
                g.setComposite(normalBlend);
            }
            boolean showClonePt = this.showClonePts && this.model.isEditingCurve(curve) && this.model.hasClonePoint(curve);
            curve.paint(g, showClonePt);
        }
        g.setTransform(oldTransform);
        g.setComposite(oldComposite);
        g.setRenderingHints(oldHints);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    @Override
    public void editingCurveChanged(Curve oldCurve, Curve newCurve) {
        Rectangle2D bounds;
        Set curves = this.getCurves();
        if (curves.contains(newCurve)) {
            newCurve.highlightAll();
            newCurve.setShowInnerShape(true);
            bounds = this.getPaintBounds(newCurve);
            if (bounds != null) {
                this.repaint(bounds);
            }
        }
        if (curves.contains(oldCurve)) {
            oldCurve.resetHighlights();
            oldCurve.setShowInnerShape(false);
            if (this.selection.isSelected(oldCurve)) {
                oldCurve.highlightAllSegments();
            }
            if ((bounds = this.getPaintBounds(oldCurve)) != null) {
                this.repaint(bounds);
            }
        }
    }

    @Override
    public void modeChanged(RegionMode oldMode, RegionMode newMode) {
        if (oldMode != null) {
            this.removeMouseListener(oldMode);
            this.removeMouseMotionListener(oldMode);
        }
        if (newMode != null) {
            this.addMouseListener(newMode);
            this.addMouseMotionListener(newMode);
        }
    }
}

